/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataFilterChain
implements MetadataFilter {
    private Logger log = LoggerFactory.getLogger(MetadataFilterChain.class);
    private ArrayList<MetadataFilter> filters = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doFilter(XMLObject xmlObject) throws FilterException {
        ArrayList<MetadataFilter> arrayList = this.filters;
        synchronized (arrayList) {
            if (this.filters == null || this.filters.isEmpty()) {
                this.log.debug("No filters configured, nothing to do");
            }
            for (MetadataFilter filter : this.filters) {
                this.log.debug("Applying filter {}", (Object)filter.getClass().getName());
                filter.doFilter(xmlObject);
            }
        }
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<MetadataFilter> newFilters) {
        this.filters.clear();
        if (newFilters != null) {
            this.filters.addAll(newFilters);
        }
    }
}

