/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.JNDIConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JNDITopicConnectionFactory
extends JNDIConnectionFactory
implements TopicConnectionFactory {
    private static final Logger log = Logger.getLogger(JNDITopicConnectionFactory.class);

    private TopicConnectionFactory getFactory() throws JMSException {
        TopicConnectionFactory factory;
        Context ctx = null;
        try {
            ctx = this.createContext();
            factory = (TopicConnectionFactory)ctx.lookup(this.getBinding());
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new JMSException(e.getMessage());
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    log.error((Object)("closing JNDI context: " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
        return factory;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.getFactory().createTopicConnection();
    }

    public TopicConnection createTopicConnection(String arg0, String arg1) throws JMSException {
        return this.getFactory().createTopicConnection(arg0, arg1);
    }
}

