/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesRepository;
import hermes.browser.HermesBrowser;
import hermes.browser.actions.BrowseContextAction;
import hermes.browser.actions.BrowserAction;
import hermes.browser.actions.MessageStoreBrowserAction;
import hermes.browser.actions.QueueBrowseAction;
import hermes.browser.actions.RegexQueueBrowseAction;
import hermes.browser.actions.RepositoryFileBrowserAction;
import hermes.browser.actions.StringSearchQueueBrowseAction;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.QueueWatchTableModel;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.tasks.CopyOrMoveMessagesTask;
import hermes.browser.tasks.DeleteMessagesFromStoreTask;
import hermes.browser.tasks.DestinationWatchAction;
import hermes.browser.tasks.DiscoverDestinationsTask;
import hermes.browser.tasks.SendMessageTask;
import hermes.browser.tasks.TruncateQueueTask;
import hermes.config.DestinationConfig;
import hermes.config.NamingConfig;
import hermes.store.MessageStore;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JComponent;

public class ActionFactory {
    private HermesBrowser hermesBrowser;

    public ActionFactory(HermesBrowser hermesBrowser) {
        this.hermesBrowser = hermesBrowser;
    }

    public DestinationWatchAction createDestinationWatchAction(String id, JComponent forRepaint, QueueWatchTableModel watchModel) throws JMSException {
        DestinationWatchAction rval = new DestinationWatchAction(id, forRepaint, watchModel);
        rval.start();
        return rval;
    }

    public BrowseContextAction createBrowseContextAction(NamingConfig namingConfig) {
        return new BrowseContextAction(namingConfig);
    }

    public DiscoverDestinationsTask createDiscoverDestinationAction(BrowserTreeModel treeModel, HermesTreeNode hermeNode) throws JMSException {
        DiscoverDestinationsTask rval = new DiscoverDestinationsTask(treeModel, hermeNode);
        rval.start();
        return rval;
    }

    public BrowserAction createMessageStoreBrowseAction(MessageStore messageStore, Hermes hermes, Destination destination, String selector) throws JMSException {
        MessageStoreBrowserAction rval = new MessageStoreBrowserAction(hermes, messageStore, destination, selector);
        rval.init();
        return rval;
    }

    public BrowserAction createMessageStoreBrowseAction(MessageStore messageStore, Hermes hermes, String selector) throws JMSException {
        MessageStoreBrowserAction rval = new MessageStoreBrowserAction(hermes, messageStore, null, selector);
        rval.init();
        return rval;
    }

    public BrowserAction createRepositoryBrowseAction(HermesRepository repository, Hermes hermes) throws JMSException {
        int maxCachedMessages = this.hermesBrowser.getMaxMessagesInBrowserPane();
        RepositoryFileBrowserAction rval = new RepositoryFileBrowserAction(hermes, repository, maxCachedMessages);
        rval.init();
        return rval;
    }

    public BrowserAction createRepositoryBrowseAction(HermesRepository repository) throws JMSException {
        int maxCachedMessages = this.hermesBrowser.getMaxMessagesInBrowserPane();
        RepositoryFileBrowserAction rval = new RepositoryFileBrowserAction(repository, maxCachedMessages);
        rval.init();
        return rval;
    }

    public BrowserAction createQueueBrowseAction(Hermes hermes, DestinationConfig dConfig) throws JMSException {
        int maxCachedMessages = this.hermesBrowser.getMaxMessagesInBrowserPane();
        QueueBrowseAction rval = new QueueBrowseAction(hermes, dConfig, maxCachedMessages, null);
        rval.init();
        return rval;
    }

    public BrowserAction createRegexQueueBrowseAction(Hermes hermes, DestinationConfig config, String regex) throws JMSException {
        int maxCachedMessages = this.hermesBrowser.getMaxMessagesInBrowserPane();
        RegexQueueBrowseAction rval = null;
        rval = config != null ? new RegexQueueBrowseAction(hermes, config, regex, maxCachedMessages) : new RegexQueueBrowseAction(hermes, regex, maxCachedMessages);
        rval.init();
        return rval;
    }

    public BrowserAction createStringSeachQueueBrowseAction(Hermes hermes, DestinationConfig config, String regex, boolean seachUserHeader) throws JMSException {
        int maxCachedMessages = this.hermesBrowser.getMaxMessagesInBrowserPane();
        StringSearchQueueBrowseAction rval = null;
        rval = config != null ? new StringSearchQueueBrowseAction(hermes, config, regex, seachUserHeader, maxCachedMessages) : new StringSearchQueueBrowseAction(hermes, regex, seachUserHeader, maxCachedMessages);
        rval.init();
        return rval;
    }

    public CopyOrMoveMessagesTask createMessageCopyAction(Hermes hermes, String d, Domain domain, Collection set) {
        CopyOrMoveMessagesTask rval = new CopyOrMoveMessagesTask(hermes, d, domain, set, 1);
        rval.start();
        return rval;
    }

    public CopyOrMoveMessagesTask createMessageMoveAction(Hermes hermes, String d, Domain domain, Collection set) {
        CopyOrMoveMessagesTask rval = new CopyOrMoveMessagesTask(hermes, d, domain, set, 2);
        rval.start();
        return rval;
    }

    public SendMessageTask createSimpleSendMessageAction(Hermes hermes, String d, Domain domain, File file, int isXML) {
        SendMessageTask rval = new SendMessageTask(hermes, d, domain, file, isXML);
        rval.start();
        return rval;
    }

    public SendMessageTask createSimpleSendMessageAction(Hermes hermes, String d, Domain domain, String xml) {
        SendMessageTask rval = new SendMessageTask(hermes, d, domain, xml);
        rval.start();
        return rval;
    }

    public SendMessageTask createSimpleSendMessageAction(Hermes hermes, String d, Domain domain, List files, int isXML) {
        SendMessageTask rval = new SendMessageTask(hermes, d, domain, files, isXML);
        rval.start();
        return rval;
    }

    public TruncateQueueTask createTruncateAction(Hermes hermes, DestinationConfig destination) throws JMSException {
        TruncateQueueTask rval = new TruncateQueueTask(hermes, destination, true);
        rval.start();
        return rval;
    }

    public DeleteMessagesFromStoreTask createDeleteFromMessageStoreAction(MessageStore store, Collection<Message> messages, boolean warning) throws JMSException {
        DeleteMessagesFromStoreTask rval = new DeleteMessagesFromStoreTask(store, messages, warning);
        rval.start();
        return rval;
    }

    public TruncateQueueTask createTruncateAction(Hermes hermes, DestinationConfig destination, Collection messageIds, boolean warning) throws JMSException {
        TruncateQueueTask rval = new TruncateQueueTask(hermes, destination, messageIds, warning);
        rval.start();
        return rval;
    }
}

