/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import hermes.browser.IconCache;
import hermes.browser.JTableButtonMouseListener;
import hermes.browser.JTableButtonRenderer;
import hermes.browser.model.ActionsPanelTableModel;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.TaskListener;
import hermes.browser.tasks.TaskSupport;
import hermes.swing.SwingRunner;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class ActionsPanel
extends JTable
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private static final Category cat = Category.getInstance(ActionsPanel.class);
    private final ActionsPanelTableModel actionsTableModel = new ActionsPanelTableModel();
    private final Map<Task, Vector> rowInfo = new HashMap<Task, Vector>();
    private final Map<Vector, Task> taskInfo = new HashMap<Vector, Task>();

    public ActionsPanel() {
        this.init();
        TaskSupport.addGlobalListener(this);
    }

    public void init() {
        this.setModel(this.actionsTableModel);
        this.setDefaultRenderer(JButton.class, new JTableButtonRenderer(this.getDefaultRenderer(JButton.class)));
        this.addMouseListener(new JTableButtonMouseListener(this));
        this.getColumnModel().getColumn(0).setMaxWidth(20);
        this.getColumnModel().getColumn(1).setMaxWidth(20);
        this.setRowHeight(20);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ActionsPanel.this.maybeChangeFocus(e);
                }
            }
        });
    }

    public void maybeChangeFocus(MouseEvent e) {
    }

    @Override
    public void onStarted(final Task task) {
        SwingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector<Object> row = new Vector<Object>();
                JButton stopButton = new JButton(IconCache.getIcon("hermes.stop"));
                stopButton.setToolTipText("Stop");
                row.add(task.getIcon());
                row.add(stopButton);
                row.add(task.getTitle());
                ActionsPanel.this.rowInfo.put(task, row);
                ActionsPanel.this.taskInfo.put(row, task);
                if (task.isRunning()) {
                    ActionsPanel.this.actionsTableModel.addRow(row);
                    stopButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            task.stop();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onStatus(Task task, String status) {
    }

    @Override
    public void onStopped(final Task task) {
        SwingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Vector oldRow = (Vector)ActionsPanel.this.rowInfo.get(task);
                if (task != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ActionsPanel.this.actionsTableModel.removeRow(oldRow);
                            ActionsPanel.this.rowInfo.remove(task);
                            ActionsPanel.this.taskInfo.remove(oldRow);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onThrowable(Task task, Throwable t) {
    }
}

