/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import hermes.Domain;
import hermes.HermesRuntimeException;
import hermes.JNDIConnectionFactory;
import hermes.JNDIQueueConnectionFactory;
import hermes.JNDITopicConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.components.ContextTreeCellRenderer;
import hermes.browser.components.PopupMenuFactory;
import hermes.browser.dialog.BeanPropertyDialog;
import hermes.browser.dialog.BindToolDialog;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.ConnectionFactoryTreeNode;
import hermes.browser.model.tree.ContextTreeModel;
import hermes.browser.model.tree.ContextTreeNode;
import hermes.browser.model.tree.ExceptionTreeNode;
import hermes.browser.model.tree.QueueTopicTreeNode;
import hermes.browser.model.tree.QueueTreeNode;
import hermes.browser.model.tree.TopicTreeNode;
import hermes.browser.transferable.ContextTreeTransferHandler;
import hermes.browser.transferable.HermesAdministeredObjectTransferable;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import java.awt.Frame;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Destination;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ContextTree
extends JTree {
    private static final Logger log = Logger.getLogger(ContextTree.class);
    private JidePopupMenu popupMenu;

    public ContextTree() {
        this.init();
    }

    public Collection<FactoryConfig> getSelectedConnectionFactories() {
        ArrayList<FactoryConfig> rval = new ArrayList<FactoryConfig>();
        try {
            if (this.getSelectionPaths() != null) {
                for (TreePath selectionPath : this.getSelectionPaths()) {
                    AbstractTreeNode node;
                    Object component = selectionPath.getLastPathComponent();
                    if (!(component instanceof AbstractTreeNode) || !((node = (AbstractTreeNode)component) instanceof ConnectionFactoryTreeNode)) continue;
                    ContextTreeNode ctxNode = (ContextTreeNode)node.getParent();
                    ConnectionFactoryTreeNode cfNode = (ConnectionFactoryTreeNode)node;
                    String binding = this.getAbsoluteBinding(cfNode);
                    Class clazz = null;
                    clazz = cfNode.getBean() instanceof QueueConnectionFactory && cfNode.getBean() instanceof TopicConnectionFactory ? JNDIConnectionFactory.class : (cfNode.getBean() instanceof QueueConnectionFactory ? JNDIQueueConnectionFactory.class : JNDITopicConnectionFactory.class);
                    FactoryConfig factoryConfig = HermesBrowser.getConfigDAO().createJNDIFactoryConfig(ctxNode.getConfig().getClasspathId(), "S:" + System.currentTimeMillis() + ":" + node.getId(), binding, ctxNode.getConfig().getProperties(), clazz.getName());
                    rval.add(factoryConfig);
                }
            }
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return rval;
    }

    public boolean doImport(Transferable t) {
        try {
            ContextTreeModel model = (ContextTreeModel)this.getModel();
            String bindingRoot = this.getAbsoluteBinding((TreeNode)this.getSelectionPath().getLastPathComponent());
            Collection objects = (Collection)t.getTransferData(HermesAdministeredObjectTransferable.FLAVOR);
            BindToolDialog bindTool = new BindToolDialog((Frame)((Object)HermesBrowser.getBrowser()), model.getContextFactory(), bindingRoot, objects);
            log.debug((Object)("got " + objects.size() + " objects to bind relative to " + bindingRoot));
            bindTool.pack();
            JideSwingUtilities.centerWindow((Window)((Object)bindTool));
            bindTool.show();
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesRuntimeException(e);
        }
    }

    protected String getAbsoluteBinding(TreeNode leaf) {
        ContextTreeModel model = (ContextTreeModel)this.getModel();
        TreeNode[] path = model.getPathToRoot(leaf);
        StringBuffer rval = new StringBuffer();
        for (int i = 1; i < path.length; ++i) {
            AbstractTreeNode node = (AbstractTreeNode)path[i];
            rval.append(node.getId());
            if (i == path.length - 1 || node.getId().endsWith("/")) continue;
            rval.append("/");
        }
        return rval.toString();
    }

    public Collection<DestinationConfig> getSelectedDestinations() {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        if (this.getSelectionPaths() != null) {
            for (TreePath selectionPath : this.getSelectionPaths()) {
                AbstractTreeNode node;
                Object component = selectionPath.getLastPathComponent();
                if (!(component instanceof AbstractTreeNode) || !((node = (AbstractTreeNode)component) instanceof QueueTopicTreeNode) && !(node instanceof QueueTreeNode) && !(node instanceof TopicTreeNode)) continue;
                DestinationConfig config = HermesBrowser.getConfigDAO().createDestinationConfig();
                String binding = this.getAbsoluteBinding(node);
                config.setName(binding);
                config.setDomain(Domain.getDomain((Destination)node.getBean()).getId());
                rval.add(config);
            }
        }
        return rval;
    }

    private void init() {
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new ContextTreeCellRenderer());
        this.setDragEnabled(true);
        this.setTransferHandler(new ContextTreeTransferHandler(this));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ContextTree.this.onMouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContextTree.this.onDoubleClick();
                }
            }
        });
        this.popupMenu = PopupMenuFactory.createContextTreePopup(this);
    }

    private void onMouseReleased(MouseEvent e) {
        TreePath currentPath = this.getPathForLocation(e.getX(), e.getY());
        if (currentPath != null && e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void onDoubleClick() {
        if (this.getSelectionPath() != null) {
            AbstractTreeNode node;
            if (this.getSelectionPath().getLastPathComponent() instanceof ExceptionTreeNode) {
                ExceptionTreeNode node2 = (ExceptionTreeNode)this.getSelectionPath().getLastPathComponent();
                HermesBrowser.getBrowser().showErrorDialog(node2.getException().getClass().getName() + "\n" + node2.getException());
            } else if (this.getSelectionPath().getLastPathComponent() instanceof AbstractTreeNode && !((node = (AbstractTreeNode)this.getSelectionPath().getLastPathComponent()) instanceof ContextTreeNode)) {
                BeanPropertyDialog dialog = new BeanPropertyDialog((Frame)((Object)HermesBrowser.getBrowser()), node.getBean(), false);
                dialog.pack();
                JideSwingUtilities.centerWindow((Window)((Object)dialog));
                dialog.show();
            }
        }
    }
}

