/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.swing.JideScrollPane;
import hermes.JNDIConnectionFactory;
import hermes.JNDIQueueConnectionFactory;
import hermes.JNDITopicConnectionFactory;
import hermes.NullConnectionFactory;
import hermes.SingletonManager;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.PropertySetTableModel;
import hermes.config.FactoryConfig;
import hermes.config.HermesConfig;
import hermes.config.ProviderConfig;
import hermes.impl.ClassLoaderManager;
import hermes.providers.file.FileConnectionFactory;
import hermes.util.ReflectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class ConnectionFactoryConfigPanel
extends JPanel {
    private static final String CLASS = "class";
    private static final String CONNECTION_FACTORY = "Connection Factory";
    private static final String REMOVE_PROPERTY = "Remove property";
    private static final String ADD_PROPERTY = "Add property";
    private static final Logger log = Logger.getLogger(ConnectionFactoryConfigPanel.class);
    private static final Set<String> defaultFactories = new HashSet<String>();
    private PreferencesDialog dialog;
    private FactoryConfig factoryConfig;
    private SortableTable propertyTable = new SortableTable();
    private JComboBox connectionFactoryComboBox = new JComboBox();
    private DefaultComboBoxModel connectionFactoryComboBoxModel = new DefaultComboBoxModel();
    private JideScrollPane propertyTableSP = new JideScrollPane();
    private JComboBox propertySelectionComboBox;
    private JComboBox classLoaderComboBox = new JComboBox();
    private PropertySetTableModel propertyTableModel;
    private ConnectionFactory bean;

    public ConnectionFactoryConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public String getLoader() {
        return (String)this.classLoaderComboBox.getSelectedItem();
    }

    public void init() {
        Border border = BorderFactory.createBevelBorder(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(border, CONNECTION_FACTORY));
        this.connectionFactoryComboBox.setModel(this.connectionFactoryComboBoxModel);
        this.propertyTableSP.setViewportView((Component)this.propertyTable);
        this.propertyTable.setSortable(true);
        JPanel topPanel = new JPanel();
        BoxLayout layout = new BoxLayout(topPanel, 2);
        topPanel.setLayout(layout);
        JLabel classLabel = new JLabel("Class:", 4);
        JLabel loaderLabel = new JLabel("Loader:", 4);
        classLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        loaderLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        topPanel.add(classLabel);
        topPanel.add(this.connectionFactoryComboBox);
        topPanel.add(loaderLabel);
        topPanel.add(this.classLoaderComboBox);
        this.add((Component)topPanel, "North");
        this.add((Component)this.propertyTableSP, "Center");
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem addItem = new JMenuItem(ADD_PROPERTY);
        final JMenuItem removeItem = new JMenuItem(REMOVE_PROPERTY);
        popupMenu.add(addItem);
        popupMenu.add(removeItem);
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ConnectionFactoryConfigPanel.this.propertyTableModel.insertRow();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ConnectionFactoryConfigPanel.this.propertyTable.getSelectedRow() != -1) {
                    ConnectionFactoryConfigPanel.this.propertyTableModel.removeRow(ConnectionFactoryConfigPanel.this.propertyTable.getSelectedRow());
                }
            }
        });
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (e.getComponent() == ConnectionFactoryConfigPanel.this.propertyTableSP) {
                        removeItem.setEnabled(false);
                    } else {
                        removeItem.setEnabled(true);
                    }
                    if (ConnectionFactoryConfigPanel.this.propertySelectionComboBox.getModel().getSize() == 0) {
                        addItem.setEnabled(false);
                    } else {
                        addItem.setEnabled(true);
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.propertyTableSP.addMouseListener((MouseListener)m);
        this.propertyTable.addMouseListener((MouseListener)m);
        this.propertyTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.connectionFactoryComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                String className = (String)ConnectionFactoryConfigPanel.this.connectionFactoryComboBoxModel.getSelectedItem();
                try {
                    if (ConnectionFactoryConfigPanel.this.propertyTableModel != null) {
                        String classLoaderId = (String)ConnectionFactoryConfigPanel.this.classLoaderComboBox.getSelectedItem();
                        ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
                        ClassLoader classLoader = classLoaderManager.getClassLoader(classLoaderId);
                        ConnectionFactoryConfigPanel.this.bean = ReflectUtils.createConnectionFactory(classLoader.loadClass(className));
                        ConnectionFactoryConfigPanel.this.propertyTableModel.setBean(ConnectionFactoryConfigPanel.this.bean);
                        ConnectionFactoryConfigPanel.this.updateCellEditor();
                        ConnectionFactoryConfigPanel.this.dialog.setDirty();
                    }
                }
                catch (Throwable e) {
                    HermesBrowser.getBrowser().showErrorDialog(e);
                    log.error((Object)e.getMessage(), e);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
            }
        });
    }

    private void updateConectionFactories() {
        String classpathGroupId = (String)this.classLoaderComboBox.getSelectedItem();
        ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
        if (classpathGroupId == null) {
            classpathGroupId = this.factoryConfig.getClasspathId();
        }
        HashSet<String> factories = new HashSet<String>();
        if (classLoaderManager.getFactories(classpathGroupId) != null) {
            factories.addAll(classLoaderManager.getFactories(classpathGroupId));
        }
        factories.addAll(defaultFactories);
        this.connectionFactoryComboBoxModel.removeAllElements();
        if (!factories.contains(this.factoryConfig.getProvider().getClassName())) {
            log.error((Object)"factory lost!");
        } else {
            this.connectionFactoryComboBoxModel.addElement(this.factoryConfig.getProvider().getClassName());
            this.connectionFactoryComboBoxModel.setSelectedItem(this.factoryConfig.getProvider().getClassName());
        }
        for (String factoryClassName : factories) {
            if (this.connectionFactoryComboBoxModel.getIndexOf(factoryClassName) != -1) continue;
            this.connectionFactoryComboBoxModel.addElement(factoryClassName);
        }
    }

    public FactoryConfig getFactoryConfig() {
        return this.factoryConfig;
    }

    public void setFactoryConfig(HermesConfig hConfig, FactoryConfig newFactory) {
        if (newFactory.getProvider() == null) {
            newFactory.setProvider(new ProviderConfig());
            newFactory.getProvider().setClassName(this.factoryConfig.getProvider().getClassName());
        }
        this.factoryConfig = newFactory;
        if (this.factoryConfig.getProvider().getClassName() == null) {
            this.factoryConfig.getProvider().setClassName(NullConnectionFactory.class.getName());
        }
        if (this.factoryConfig.getClasspathId() == null) {
            this.factoryConfig.setClasspathId("System");
        }
        DefaultComboBoxModel classLoaderModel = new DefaultComboBoxModel();
        ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
        Iterator iter = classLoaderManager.getIds().iterator();
        while (iter.hasNext()) {
            classLoaderModel.addElement(iter.next());
        }
        classLoaderModel.addElement("System");
        this.classLoaderComboBox.setModel(classLoaderModel);
        this.classLoaderComboBox.setSelectedItem(this.factoryConfig.getClasspathId());
        this.updateConectionFactories();
        classLoaderModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                try {
                    ConnectionFactoryConfigPanel.this.updateConectionFactories();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        ConnectionFactory bean = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class<?> clazz = classLoaderManager.getClassLoader(this.factoryConfig.getClasspathId()).loadClass(this.factoryConfig.getProvider().getClassName());
            bean = ReflectUtils.createConnectionFactory(clazz);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            HermesBrowser.getBrowser().showErrorDialog("Cannot find class " + this.factoryConfig.getProvider().getClassName() + " in loader " + this.factoryConfig.getClasspathId());
        }
        if (bean != null) {
            try {
                this.propertyTableModel = new PropertySetTableModel(bean, this.factoryConfig.getProvider().getProperties(), new HashSet());
                this.propertyTable.setModel((TableModel)this.propertyTableModel);
                this.updateCellEditor();
            }
            catch (Throwable ex) {
                HermesBrowser.getBrowser().showErrorDialog("Problems accessing " + this.factoryConfig.getProvider().getClassName(), ex);
            }
        }
        this.propertyTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                ConnectionFactoryConfigPanel.this.dialog.setDirty();
            }
        });
    }

    public void updateCellEditor() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.propertyTable.getColumnModel().getColumnCount() > 0 && this.bean != null) {
            TableColumn propertyNameColumn = this.propertyTable.getColumnModel().getColumn(0);
            this.propertySelectionComboBox = new JComboBox();
            boolean isJNDI = false;
            try {
                Map properties = BeanUtils.describe((Object)this.bean);
                for (String name : this.propertyTableModel.getValidProperties()) {
                    this.propertySelectionComboBox.addItem(name);
                }
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException().getMessage(), e.getTargetException());
            }
            propertyNameColumn.setCellEditor(new DefaultCellEditor(this.propertySelectionComboBox));
        }
    }

    public void updateModel() {
        try {
            if (this.propertyTableModel != null && this.bean != null) {
                this.factoryConfig.getProvider().getProperties().getProperty().clear();
                this.factoryConfig.getProvider().getProperties().getProperty().addAll(this.propertyTableModel.getProperties());
                this.factoryConfig.setClasspathId((String)this.classLoaderComboBox.getSelectedItem());
                this.factoryConfig.getProvider().setClassName((String)this.connectionFactoryComboBox.getSelectedItem());
            }
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        defaultFactories.add(NullConnectionFactory.class.getName());
        defaultFactories.add(JNDITopicConnectionFactory.class.getName());
        defaultFactories.add(JNDIQueueConnectionFactory.class.getName());
        defaultFactories.add(JNDIConnectionFactory.class.getName());
        defaultFactories.add(FileConnectionFactory.class.getName());
    }
}

