/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class TypedMapTableModel
extends AbstractTableModel {
    private static final Logger log = Logger.getLogger(TypedMapTableModel.class);
    private static String[] header = new String[]{"Name", "Type", "Value"};
    private Vector<Row> rows = new Vector();
    private Class[] types;
    private Class defaultClass;

    public TypedMapTableModel(Map<String, Object> map, Class[] types, Class defaultClass) {
        this.types = types;
        this.defaultClass = defaultClass;
        this.setMap(map);
    }

    public void setMap(Map<String, Object> map) {
        this.rows.clear();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Row row = new Row();
            row.name = entry.getKey();
            if (entry.getValue() != null) {
                row.value = entry.getValue();
                row.type = row.value.getClass();
                continue;
            }
            row.value = null;
            row.type = this.defaultClass;
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int y, int x) {
        Row row = this.rows.elementAt(y);
        switch (x) {
            case 0: {
                return row.name;
            }
            case 1: {
                return row.type;
            }
            case 2: {
                return row.value;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int y, int x) {
        if (y < this.rows.size()) {
            Row row = this.rows.elementAt(y);
            switch (x) {
                case 0: {
                    row.name = (String)value;
                    break;
                }
                case 1: {
                    row.type = (Class)value;
                    break;
                }
                case 2: {
                    row.value = value;
                }
            }
        }
    }

    public Class getColumnClass(int x) {
        return String.class;
    }

    @Override
    public String getColumnName(int x) {
        return header[x];
    }

    private static class Row {
        String name;
        Object value;
        Class type;

        private Row() {
        }
    }
}

