/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import com.jidesoft.swing.JideSwingUtilities;
import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.DestinationConfigDialog;
import hermes.browser.tasks.TaskSupport;
import hermes.config.DestinationConfig;
import java.awt.Frame;
import java.awt.Window;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EditDestinationPropertiesTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(EditDestinationPropertiesTask.class);
    private Hermes hermes;
    private Destination destination;
    private DestinationConfig config;
    private Runnable onOK;

    public EditDestinationPropertiesTask(Hermes hermes, DestinationConfig config) {
        super(IconCache.getIcon("jms.unknown"));
        this.hermes = hermes;
        this.config = config;
    }

    public EditDestinationPropertiesTask(Hermes hermes, DestinationConfig config, Runnable onOK) {
        this(hermes, config);
        this.onOK = onOK;
    }

    @Override
    public void invoke() throws Exception {
        if (this.config.getName() != null) {
            Hermes.ui.getDefaultMessageSink().add("Getting properties for " + this.config.getName() + "...");
            try {
                this.destination = this.hermes.getDestination(this.config.getName(), Domain.getDomain(this.config.getDomain()));
            }
            catch (JMSException ex) {
                Hermes.ui.getDefaultMessageSink().add("Unable to create a session to get destination bean properties. " + ex.getMessage());
            }
        }
        if (this.destination != null) {
            Hermes.ui.getDefaultMessageSink().add("Getting properties for " + this.config.getName() + "... done.");
            try {
                this.hermes.close();
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DestinationConfigDialog dialog = new DestinationConfigDialog((Frame)((Object)HermesBrowser.getBrowser()), EditDestinationPropertiesTask.this.hermes.getId(), EditDestinationPropertiesTask.this.destination, EditDestinationPropertiesTask.this.config);
                dialog.pack();
                JideSwingUtilities.centerWindow((Window)((Object)dialog));
                dialog.show();
                if (EditDestinationPropertiesTask.this.onOK != null) {
                    EditDestinationPropertiesTask.this.onOK.run();
                }
            }
        });
    }
}

