/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix.quickfix;

import hermes.fix.FIXMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import quickfix.Message;
import quickfix.mina.message.FIXMessageDecoder;

public class QuickFIXMessageCache {
    private LRUMap messages;
    private Set<FIXMessage> toReset = new HashSet<FIXMessage>();
    private Lock lock = new ReentrantLock();
    private Map<Thread, FIXMessageDecoder> decoders = new HashMap<Thread, FIXMessageDecoder>();

    public QuickFIXMessageCache() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FIXMessageDecoder getDecoder() {
        Map<Thread, FIXMessageDecoder> map = this.decoders;
        synchronized (map) {
            FIXMessageDecoder decoder = this.decoders.get(Thread.currentThread());
            if (decoder == null) {
                decoder = new FIXMessageDecoder();
                this.decoders.put(Thread.currentThread(), decoder);
            }
            return decoder;
        }
    }

    public QuickFIXMessageCache(int size) {
        this.messages = this.createLRUMap(size);
    }

    private LRUMap createLRUMap(int size) {
        return new LRUMap(size){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
                FIXMessage message = (FIXMessage)entry.getKey();
                Set set = QuickFIXMessageCache.this.toReset;
                synchronized (set) {
                    QuickFIXMessageCache.this.toReset.add(message);
                }
                return super.removeLRU(entry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) {
        this.lock.lock();
        try {
            LRUMap newMessages = this.createLRUMap(size);
            this.messages.putAll((Map)newMessages);
            this.messages = newMessages;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.lock.lock();
        try {
            if (this.messages == null) {
                int n = 0;
                return n;
            }
            int n = this.messages.maxSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            this.messages.clear();
            this.decoders.clear();
        }
        finally {
            this.lock.unlock();
        }
        Set<FIXMessage> set = this.toReset;
        synchronized (set) {
            this.toReset.clear();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(FIXMessage key) {
        this.lock.lock();
        try {
            boolean bl = this.messages.containsKey((Object)key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(FIXMessage key, Message value) {
        this.lock.lock();
        try {
            this.messages.put((Object)key, (Object)value);
        }
        finally {
            this.lock.unlock();
        }
        Set<FIXMessage> set = this.toReset;
        synchronized (set) {
            if (this.toReset.contains(key)) {
                this.toReset.remove(key);
            }
            for (FIXMessage m : this.toReset) {
                m.reset();
            }
            this.toReset.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get(FIXMessage key) {
        this.lock.lock();
        try {
            Message message = (Message)this.messages.get((Object)key);
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }
}

