/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Hermes;
import hermes.HermesException;
import hermes.impl.ConnectionManager;
import hermes.impl.jms.ConnectionManagerSupport;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.log4j.Category;

public class ConnectionSharedManager
extends ConnectionManagerSupport
implements ConnectionManager {
    private static final Category cat = Category.getInstance(ConnectionSharedManager.class);
    private Connection connection;

    @Override
    public void reconnect(String username, String password) throws JMSException {
        ConnectionFactory connectionFactory = (ConnectionFactory)this.parent.getObject();
        if (connectionFactory == null) {
            throw new HermesException("No ConnectionFactory has been created for this provider");
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException ex) {
            cat.warn((Object)("previous connection throw exception during close: " + ex.getMessage()));
        }
        cat.debug((Object)("creating connection from factory: " + this.parent));
        this.connection = username != null ? this.createConnection(username, password) : this.createConnection();
    }

    @Override
    public void connect() throws JMSException {
        this.reconnect(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws JMSException {
        ConnectionSharedManager connectionSharedManager = this;
        synchronized (connectionSharedManager) {
            if (this.connection == null) {
                this.connect();
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        ConnectionSharedManager connectionSharedManager = this;
        synchronized (connectionSharedManager) {
            if (this.connection != null) {
                Connection tmpConnection = this.connection;
                if (System.getProperty("hermes.dontCloseConnections") == null) {
                    try {
                        this.connection = null;
                        tmpConnection.close();
                        this.getConnectionFactoryManager().close();
                    }
                    finally {
                        Hermes.events.notifyDisconnected(this.getHermes());
                    }
                }
            }
        }
    }

    @Override
    public Object getObject() throws JMSException {
        return this.getConnection();
    }

    @Override
    public ConnectionManager.Policy getType() {
        return ConnectionManager.Policy.SHARED_CONNECTION;
    }
}

