/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.HermesException;
import hermes.providers.file.FileConnectionFactory;
import hermes.providers.file.FileSession;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.log4j.Logger;

public class FileConnection
implements QueueConnection {
    private static final Logger log = Logger.getLogger(FileConnection.class);
    private String clientID;
    private ExceptionListener exceptionListener;
    private FileConnectionFactory factory;
    private Collection tasksOnStart = new ArrayList();
    private boolean started = false;

    public FileConnection(FileConnectionFactory factory) {
        this.factory = factory;
    }

    public void close() throws JMSException {
        log.debug((Object)"close()");
    }

    public String getClientID() throws JMSException {
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return null;
    }

    public void setClientID(String clientID) throws JMSException {
        this.clientID = clientID;
    }

    public void setExceptionListener(ExceptionListener arg0) throws JMSException {
        this.exceptionListener = arg0;
    }

    public synchronized void start() throws JMSException {
        if (!this.started) {
            this.started = true;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Runnable r : FileConnection.this.tasksOnStart) {
                        r.run();
                    }
                }
            });
            t.start();
        }
    }

    public void stop() throws JMSException {
    }

    public ConnectionConsumer createConnectionConsumer(Queue arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        throw new HermesException("Not available with File provider");
    }

    public QueueSession createQueueSession(boolean arg0, int arg1) throws JMSException {
        return new FileSession(this, arg0, arg1);
    }

    public FileConnectionFactory getFactory() {
        return this.factory;
    }

    public synchronized void doOnStart(final Runnable r) {
        if (this.started) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    r.run();
                }
            });
        } else {
            this.tasksOnStart.add(r);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        return null;
    }

    public Session createSession(boolean arg0, int arg1) throws JMSException {
        return new FileSession(this, arg0, arg1);
    }
}

