/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import hermes.browser.MessageRenderer;
import hermes.renderers.AbstractMessageRenderer;
import hermes.util.DumpUtils;
import hermes.util.MessageUtils;
import java.awt.Font;
import java.io.StringWriter;
import javax.jms.Message;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class EBCDICMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(EBCDICMessageRenderer.class);
    private static String MAX_MESSAGE_SIZE = "maxMessageSize";
    private static String MAX_MESSAGE_SIZE_INFO = "Maximum message size";
    private static String UNDISPLAYABLE_CHAR = ".";
    private static String ROW_LENGTH = "rowLength";
    private static String ROW_LENGTH_INFO = "Row length to display on screen";
    private static String UNDISPLAYABLE_CHAR_INFO = "Character to display when the EBCDIC character cannot be represented in ASCII";
    public static final int DUMP_AS_EBCDIC = 5;
    public char[] chart = null;
    public MyConfig config = new MyConfig();

    @Override
    public MessageRenderer.Config createConfig() {
        return new MyConfig();
    }

    @Override
    public void setConfig(MessageRenderer.Config config) {
        this.config = (MyConfig)config;
        this.updateMappings();
        super.setConfig(config);
    }

    private void updateMappings() {
        this.chart = new char[255];
        for (int i = 0; i < 255; ++i) {
            this.chart[i] = this.config.getUndisplayableChar().charAt(0);
        }
        this.chart[64] = 32;
        this.chart[76] = 60;
        this.chart[77] = 40;
        this.chart[78] = 43;
        this.chart[79] = 124;
        this.chart[80] = 38;
        this.chart[90] = 33;
        this.chart[91] = 36;
        this.chart[92] = 42;
        this.chart[93] = 41;
        this.chart[94] = 59;
        this.chart[95] = 95;
        this.chart[96] = 45;
        this.chart[97] = 47;
        this.chart[107] = 44;
        this.chart[108] = 37;
        this.chart[109] = 95;
        this.chart[110] = 62;
        this.chart[111] = 63;
        this.chart[122] = 58;
        this.chart[123] = 35;
        this.chart[124] = 64;
        this.chart[125] = 96;
        this.chart[126] = 61;
        this.chart[127] = 34;
        this.chart[129] = 97;
        this.chart[130] = 98;
        this.chart[131] = 99;
        this.chart[132] = 100;
        this.chart[133] = 101;
        this.chart[134] = 102;
        this.chart[135] = 103;
        this.chart[136] = 104;
        this.chart[137] = 105;
        this.chart[145] = 106;
        this.chart[146] = 107;
        this.chart[147] = 108;
        this.chart[148] = 109;
        this.chart[149] = 110;
        this.chart[150] = 111;
        this.chart[151] = 112;
        this.chart[152] = 113;
        this.chart[153] = 114;
        this.chart[162] = 115;
        this.chart[163] = 116;
        this.chart[164] = 117;
        this.chart[165] = 118;
        this.chart[166] = 119;
        this.chart[167] = 120;
        this.chart[168] = 121;
        this.chart[169] = 122;
        this.chart[193] = 65;
        this.chart[194] = 66;
        this.chart[195] = 67;
        this.chart[196] = 68;
        this.chart[197] = 69;
        this.chart[198] = 70;
        this.chart[199] = 71;
        this.chart[200] = 72;
        this.chart[201] = 73;
        this.chart[209] = 74;
        this.chart[210] = 75;
        this.chart[211] = 76;
        this.chart[212] = 77;
        this.chart[213] = 78;
        this.chart[214] = 79;
        this.chart[215] = 80;
        this.chart[216] = 81;
        this.chart[217] = 82;
        this.chart[226] = 83;
        this.chart[227] = 84;
        this.chart[228] = 85;
        this.chart[229] = 86;
        this.chart[230] = 87;
        this.chart[231] = 88;
        this.chart[232] = 89;
        this.chart[233] = 90;
        this.chart[240] = 48;
        this.chart[241] = 49;
        this.chart[242] = 50;
        this.chart[243] = 51;
        this.chart[244] = 52;
        this.chart[245] = 53;
        this.chart[246] = 54;
        this.chart[247] = 55;
        this.chart[248] = 56;
        this.chart[249] = 57;
    }

    @Override
    public JComponent render(Message m) {
        JTextArea myRender = new JTextArea();
        myRender.setEditable(false);
        myRender.setFont(Font.decode("Monospaced-PLAIN-12"));
        byte[] messagebytes = null;
        try {
            messagebytes = MessageUtils.asBytes(m);
        }
        catch (Exception j) {
            log.error((Object)j.getMessage(), (Throwable)j);
        }
        try {
            myRender.setText(this.dumpBinaryEx(messagebytes, 5, this.config.getMaxMessageSize()));
            myRender.setCaretPosition(0);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return myRender;
    }

    private String dumpBinaryEx(byte[] data, int mode, int maxSize) {
        StringWriter b = new StringWriter();
        int c = 0;
        if (data != null) {
            while (c < data.length) {
                int max = Math.min(this.config.getRowLength(), data.length - c);
                byte[] row = new byte[max];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = data[c + i];
                }
                switch (mode) {
                    case 5: {
                        DumpUtils.dumpBinaryLineAsHexAndEBCDIC(b, c, this.chart, row, this.config.getRowLength());
                    }
                }
                if ((c += this.config.getRowLength()) <= maxSize) continue;
                b.append("Message too big");
                break;
            }
        } else {
            b.append("No payload.");
        }
        return b.toString();
    }

    @Override
    public boolean canRender(Message message) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "EBCDIC";
    }

    public class MyConfig
    extends AbstractMessageRenderer.BasicConfig {
        private int maxMessageSize = 0x500000;
        private int rowLength = 16;
        private boolean active = false;
        private String name = "EBCDIC";
        private String undisplayableChar = ".";

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPropertyDescription(String propertyName) {
            if (MAX_MESSAGE_SIZE.equals(propertyName)) {
                return MAX_MESSAGE_SIZE_INFO;
            }
            if (ROW_LENGTH.equals(propertyName)) {
                return ROW_LENGTH_INFO;
            }
            if (UNDISPLAYABLE_CHAR.equals(propertyName)) {
                return UNDISPLAYABLE_CHAR_INFO;
            }
            return propertyName;
        }

        public String getUndisplayableChar() {
            return this.undisplayableChar;
        }

        public void setUndisplayableChar(String undisplayableChar) {
            this.undisplayableChar = undisplayableChar;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public int getMaxMessageSize() {
            return this.maxMessageSize;
        }

        public void setMaxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public int getRowLength() {
            return this.rowLength;
        }

        public void setRowLength(int rowLength) {
            this.rowLength = rowLength;
        }
    }
}

