/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import hermes.browser.ConfigDialogProxy;
import hermes.browser.MessageRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class RendererHelper {
    private static final Logger cat = Logger.getLogger(RendererHelper.class);

    public static JComponent createDefaultConfigPanel(final ConfigDialogProxy dialogProxy) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        final MessageRenderer.Config theConfig = dialogProxy.getConfig();
        ArrayList<1> list = new ArrayList<1>();
        Map properties = PropertyUtils.describe((Object)theConfig);
        for (Map.Entry entry : properties.entrySet()) {
            final String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyName.equals("class") || propertyName.equals("name")) continue;
            Property displayProperty = new Property(propertyName, theConfig.getPropertyDescription(propertyName), propertyValue.getClass()){

                public void setValue(Object value) {
                    try {
                        dialogProxy.setDirty();
                        PropertyUtils.setProperty((Object)theConfig, (String)propertyName, (Object)value);
                    }
                    catch (Exception e) {
                        cat.error((Object)e.getMessage(), (Throwable)e);
                    }
                }

                public Object getValue() {
                    try {
                        return PropertyUtils.getProperty((Object)theConfig, (String)propertyName);
                    }
                    catch (Exception e) {
                        cat.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }

                public boolean hasValue() {
                    return true;
                }
            };
            list.add(displayProperty);
        }
        PropertyTableModel model = new PropertyTableModel(list);
        PropertyTable table = new PropertyTable((TableModel)model);
        table.setAutoResizeMode(4);
        PropertyPane pane = new PropertyPane(table);
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                dialogProxy.setDirty();
            }
        });
        model.expandAll();
        return pane;
    }
}

