/*
 * Decompiled with CFR 0.152.
 */
package hermes.store;

import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.store.schema.DefaultJDBCAdapter;
import hermes.store.schema.DefaultStatements;
import hermes.store.schema.JDBCAdapter;
import hermes.store.schema.Statements;
import hermes.util.JVMUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StoreUtils {
    private static final Logger log = Logger.getLogger(StoreUtils.class);
    private static JDBCAdapter adapter;
    private static Map<String, Statements> statements;

    public static String getDefaultConnectionURL() {
        if (System.getProperty("hermes.messageStore.url") != null) {
            return System.getProperty("hermes.messageStore.url");
        }
        String name = JVMUtils.getUserHome() + File.separator + ".hermes" + File.separator + "MessageStores";
        return StoreUtils.getConnectionURL(name);
    }

    public static String getConnectionURL(String provider, String databaseName, String options) {
        return "jdbc:" + provider + ":" + databaseName + ";" + options;
    }

    public static String getConnectionURL(String databaseName) {
        return "jdbc:derby:" + databaseName + ";create=true";
    }

    public static String getProvider(String url) {
        return url.split(":")[1];
    }

    public static Statements getStatements(String url) throws HermesException {
        String provider = StoreUtils.getProvider(url);
        log.debug((Object)("looking for statement for " + provider));
        if (statements.containsKey(provider)) {
            return statements.get(provider);
        }
        throw new HermesException("Unsupported JDBC provider " + provider);
    }

    public static synchronized JDBCAdapter getJDBCAdapter(String url) throws HermesException {
        if (adapter == null) {
            try {
                adapter = (JDBCAdapter)Class.forName(System.getProperty("hermes.jdbc.adapter", DefaultJDBCAdapter.class.getName())).newInstance();
                adapter.setStatements(StoreUtils.getStatements(url));
            }
            catch (Exception ex) {
                throw new HermesRuntimeException(ex);
            }
        }
        return adapter;
    }

    static {
        statements = new HashMap<String, Statements>();
        statements.put("derby", new DefaultStatements());
    }
}

