/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import hermes.swing.URLLabel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class URLRendererMouseListener
implements MouseListener {
    private static final Logger log = Logger.getLogger(URLRendererMouseListener.class);
    private JTable table;

    public URLRendererMouseListener(JTable table) {
        this.table = table;
    }

    private void forwardEvent(MouseEvent evt) {
        TableColumnModel columnModel = this.table.getColumnModel();
        int column = columnModel.getColumnIndexAtX(evt.getX());
        int row = evt.getY() / this.table.getRowHeight();
        if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
            return;
        }
        Object value = this.table.getValueAt(row, column);
        if (value instanceof URLLabel) {
            URLLabel button = (URLLabel)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, evt, button);
            button.dispatchEvent(buttonEvent);
            this.table.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }
}

