/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.DestinationFragmentTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.model.tree.MessageStoreQueueTreeNode;
import hermes.browser.model.tree.MessageStoreTopicTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.browser.model.tree.NamingConfigTreeNode;
import hermes.config.HermesConfig;
import hermes.store.MessageStore;
import hermes.swing.actions.ActionSupport;
import hermes.util.JMSUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DeleteBrowserTreeNodeAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(DeleteBrowserTreeNodeAction.class);

    public DeleteBrowserTreeNodeAction() {
        this.putValue("Name", "Delete");
        this.putValue("ShortDescription", "Delete the queue, topic, session, context or message store.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.objects.delete"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.enableOnBrowserTreeSelection(new Class[]{MessageStoreURLTreeNode.class, DestinationConfigTreeNode.class, NamingConfigTreeNode.class, HermesTreeNode.class, MessageStoreTreeNode.class, MessageStoreQueueTreeNode.class, MessageStoreTopicTreeNode.class}, (Action)this, false);
        }
    }

    private void doDelete(NamingConfigTreeNode namingNode) throws HermesException {
        HermesConfig config = HermesBrowser.getBrowser().getConfig();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)namingNode.getParent();
        HermesBrowser.getConfigDAO().removeNamingConfig(config, namingNode.getConfig().getId());
        HermesBrowser.getBrowser().saveConfig();
        Hermes.ui.getDefaultMessageSink().add(namingNode.getId() + " removed");
        int[] index = new int[]{namingNode.getParent().getIndex(namingNode)};
        Object[] objects = new Object[]{namingNode};
        parentNode.remove(namingNode);
        HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(parentNode, index, objects);
    }

    private void doDelete(MessageStoreURLTreeNode node) throws JMSException {
        HermesConfig config = HermesBrowser.getBrowser().getConfig();
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        int index = parent.getIndex(node);
        HermesBrowser.getConfigDAO().removeJDBC(config, node.getConfig());
        parent.remove(node);
        HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(parent, new int[]{index}, new Object[]{node});
        HermesBrowser.getBrowser().saveConfig();
    }

    private void doDelete(DestinationConfigTreeNode destinationNode) throws JMSException {
        HermesConfig config = HermesBrowser.getBrowser().getConfig();
        HermesTreeNode hermesNode = destinationNode.getHermesTreeNode();
        String type = destinationNode.isQueue() ? "queue" : "topic";
        HermesBrowser.getConfigDAO().removeDestination(config, hermesNode.getHermes().getId(), destinationNode.getDestinationName());
        hermesNode.getHermes().removeDestinationConfig(destinationNode.getConfig());
        HermesBrowser.getBrowser().saveConfig();
        Hermes.ui.getDefaultMessageSink().add(destinationNode.getDestinationName() + " removed");
        if (destinationNode.getParent() == hermesNode) {
            int[] index = new int[]{destinationNode.getHermesTreeNode().getIndex(destinationNode)};
            Object[] objects = new Object[]{destinationNode};
            hermesNode.remove(destinationNode);
            HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(hermesNode, index, objects);
        } else {
            AbstractTreeNode cleanupParent;
            AbstractTreeNode cleanup = destinationNode;
            do {
                cleanupParent = (AbstractTreeNode)cleanup.getParent();
                int index = cleanupParent.getIndex(cleanup);
                cleanupParent.remove(cleanup);
                HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(cleanupParent, new int[]{index}, new Object[]{cleanup});
            } while ((cleanup = cleanupParent).getChildCount() == 0 && cleanup instanceof DestinationFragmentTreeNode);
        }
    }

    private void doDelete(final MessageStoreTreeNode node) throws JMSException {
        final MessageStore store = node.getMessageStore();
        HermesBrowser.getBrowser().getThreadPool().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    store.delete();
                    store.checkpoint();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HermesBrowser.getBrowser().getBrowserTree().remove(node);
                        }
                    });
                }
                catch (Throwable e) {
                    String message = "Cannot delete from store " + store.getId();
                    try {
                        store.rollback();
                    }
                    catch (Throwable e1) {
                        log.error((Object)e1);
                    }
                    HermesBrowser.getBrowser().showErrorDialog(message, e);
                }
            }
        });
    }

    private void doDelete(final MessageStore store, final Destination destination) throws JMSException {
        HermesBrowser.getBrowser().getThreadPool().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Hermes.ui.getDefaultMessageSink().add("Deleting all messages from " + JMSUtils.getDestinationName(destination) + " in " + store.getId() + "...");
                    store.delete(destination);
                    store.checkpoint();
                    Hermes.ui.getDefaultMessageSink().add("All messages from " + JMSUtils.getDestinationName(destination) + " removed from " + store.getId() + ".");
                }
                catch (Throwable e) {
                    String message = "Cannot delete from store " + store.getId();
                    try {
                        store.rollback();
                    }
                    catch (Throwable e1) {
                        log.error((Object)e1);
                    }
                    HermesBrowser.getBrowser().showErrorDialog(message, e);
                }
            }
        });
    }

    private void doDelete(MessageStoreQueueTreeNode node) throws JMSException {
        if (node.getParent() instanceof MessageStoreTreeNode) {
            MessageStoreTreeNode parent = (MessageStoreTreeNode)node.getParent();
            this.doDelete(parent.getMessageStore(), (Destination)node.getBean());
        }
    }

    private void doDelete(MessageStoreTopicTreeNode node) throws JMSException {
        if (node.getParent() instanceof MessageStoreTreeNode) {
            MessageStoreTreeNode parent = (MessageStoreTreeNode)node.getParent();
            this.doDelete(parent.getMessageStore(), (Destination)node.getBean());
        }
    }

    private void doDelete(HermesTreeNode hermesNode) throws HermesException {
        HermesConfig config = HermesBrowser.getBrowser().getConfig();
        MutableTreeNode parentNode = (MutableTreeNode)hermesNode.getParent();
        HermesBrowser.getConfigDAO().removeHermes(config, hermesNode.getHermes().getId());
        HermesBrowser.getBrowser().saveConfig();
        Hermes.ui.getDefaultMessageSink().add(hermesNode.getHermes().getId() + " removed");
        int[] index = new int[]{parentNode.getIndex(hermesNode)};
        Object[] objects = new Object[]{hermesNode};
        parentNode.remove(hermesNode);
        HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(parentNode, index, objects);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            TreePath[] paths = HermesBrowser.getBrowser().getBrowserTree().getSelectionPaths();
            if (paths != null && paths.length > 0) {
                String msg;
                String string = msg = paths.length == 1 ? "Are you sure you want to delete this object?" : "Are you sure you want to delete these objects?";
                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), msg, "Please confirm", 0) == 0) {
                    for (TreePath path : paths) {
                        Object object = path.getLastPathComponent();
                        if (object instanceof DestinationConfigTreeNode) {
                            this.doDelete((DestinationConfigTreeNode)object);
                            continue;
                        }
                        if (object instanceof NamingConfigTreeNode) {
                            this.doDelete((NamingConfigTreeNode)object);
                            continue;
                        }
                        if (object instanceof HermesTreeNode) {
                            this.doDelete((HermesTreeNode)object);
                            continue;
                        }
                        if (object instanceof MessageStoreTreeNode) {
                            this.doDelete((MessageStoreTreeNode)object);
                            continue;
                        }
                        if (object instanceof MessageStoreQueueTreeNode) {
                            this.doDelete((MessageStoreQueueTreeNode)object);
                            continue;
                        }
                        if (object instanceof MessageStoreTopicTreeNode) {
                            this.doDelete((MessageStoreTopicTreeNode)object);
                            continue;
                        }
                        if (!(object instanceof MessageStoreURLTreeNode)) continue;
                        this.doDelete((MessageStoreURLTreeNode)object);
                    }
                }
                HermesBrowser.getBrowser().saveConfig();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            HermesBrowser.getBrowser().showErrorDialog("Cannot delete: ", ex);
        }
    }
}

