/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.swing.actions.DirectoryCache;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class SaveMessagesAsXMLAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(SaveMessagesAsXMLAction.class);

    public SaveMessagesAsXMLAction() {
        this.putValue("Name", "Save as XML...");
        this.putValue("ShortDescription", "Save selected messages encoded a XML.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.messages.save.xml.many"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            BrowserAction action;
            if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction && (action = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument()).getSelectedMessages().size() > 0) {
                JFileChooser chooser = DirectoryCache.lastSaveAsDirectory == null ? new JFileChooser(new File(HermesBrowser.getBrowser().getRepositoryManager().getDirectory())) : new JFileChooser(DirectoryCache.lastSaveAsDirectory);
                if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Save Messages...") == 0) {
                    DirectoryCache.lastSaveAsDirectory = chooser.getSelectedFile().getParentFile();
                    FileOutputStream ostream = new FileOutputStream(chooser.getSelectedFile());
                    action.getHermes().toXML(action.getSelectedMessages(), (OutputStream)ostream);
                    ostream.close();
                    if (action.getSelectedMessages().size() == 1) {
                        Hermes.ui.getDefaultMessageSink().add("Message saved");
                    } else {
                        Hermes.ui.getDefaultMessageSink().add(new Integer(action.getSelectedMessages().size()) + " messages saved");
                    }
                } else {
                    Hermes.ui.getDefaultMessageSink().add("Save messages cancelled");
                }
            }
        }
        catch (Exception e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to save:", e);
        }
    }
}

