/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.util.IoUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class MessageUtils {
    private static final Logger log = Logger.getLogger(MessageUtils.class);

    public static String asString(Message m) throws JMSException {
        if (m instanceof TextMessage) {
            return MessageUtils.asString((TextMessage)m);
        }
        if (m instanceof BytesMessage) {
            return MessageUtils.asString((BytesMessage)m);
        }
        return null;
    }

    public static byte[] asBytes(Message m) throws JMSException {
        if (m instanceof TextMessage) {
            return MessageUtils.asBytes((TextMessage)m);
        }
        if (m instanceof ObjectMessage) {
            return MessageUtils.asBytes((ObjectMessage)m);
        }
        if (m instanceof MapMessage) {
            return MessageUtils.asBytes((MapMessage)m);
        }
        if (m instanceof BytesMessage) {
            return MessageUtils.asBytes((BytesMessage)m);
        }
        if (m instanceof StreamMessage) {
            return MessageUtils.asBytes((StreamMessage)m);
        }
        return null;
    }

    public static byte[] asBytes(TextMessage m) throws JMSException {
        String s = m.getText().trim();
        byte[] bytes = null;
        if (s != null) {
            char[] chars = s.toCharArray();
            Charset cs = Charset.forName("UTF-8");
            CharBuffer cb = CharBuffer.allocate(chars.length);
            cb.put(chars);
            cb.flip();
            ByteBuffer bb = cs.encode(cb);
            return bb.array();
        }
        bytes = new byte[]{};
        return bytes;
    }

    public static byte[] asBytes(ObjectMessage m) throws JMSException {
        byte[] bytes = null;
        Serializable o = m.getObject();
        ByteArrayOutputStream bytesOut = null;
        ObjectOutputStream objectOut = null;
        try {
            bytesOut = new ByteArrayOutputStream(1024);
            objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(o);
            bytes = bytesOut.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(":" + e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(objectOut);
                IoUtils.closeQuietly(bytesOut);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(objectOut);
        IoUtils.closeQuietly(bytesOut);
        return bytes;
    }

    public static byte[] asBytes(MapMessage m) throws JMSException {
        return new byte[0];
    }

    public static long getBodyLength(BytesMessage m) throws JMSException {
        try {
            return m.getBodyLength();
        }
        catch (NoSuchMethodError e) {
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        long bytesSize = 0L;
        try {
            m.reset();
            while (true) {
                m.readByte();
                ++bytesSize;
            }
        }
        catch (MessageEOFException e2) {
        }
        catch (Exception ex) {
            log.error((Object)("unexpected exception reading bytes message, treating as EOF:" + ex.getMessage()), (Throwable)ex);
        }
        return bytesSize;
    }

    public static String asString(BytesMessage m) throws JMSException {
        StringBuffer sb = new StringBuffer();
        sb.append(MessageUtils.asBytes(m));
        return sb.toString();
    }

    public static String asString(TextMessage m) throws JMSException {
        return m.getText().trim();
    }

    public static byte[] asBytes(BytesMessage m) throws JMSException {
        byte[] bytes = null;
        long bytesSize = MessageUtils.getBodyLength(m);
        bytes = new byte[(int)bytesSize];
        m.reset();
        boolean i = false;
        try {
            m.readBytes(bytes);
        }
        catch (MessageEOFException e2) {
        }
        catch (Exception ex) {
            log.error((Object)("unexpected exception reading bytes message, treating as EOF:" + ex.getMessage()), (Throwable)ex);
        }
        return bytes;
    }

    public static byte[] asBytes(StreamMessage m) throws JMSException {
        m.reset();
        int CHUNK_SIZE = 1024;
        byte[] buffer = new byte[1024];
        ArrayList<Byte> bytes = new ArrayList<Byte>(1024);
        int bytesCopied = 0;
        int bytesRead = 0;
        do {
            bytesRead = m.readBytes(buffer);
            for (int i = 0; i < bytesRead; ++i) {
                bytes.add(new Byte(buffer[i]));
            }
            bytesCopied += bytesRead;
        } while (bytesRead != 0);
        return MessageUtils.asBytes(bytes);
    }

    public static byte[] asBytes(List l) {
        byte[] bytes = new byte[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            Byte b = (Byte)l.get(i);
            bytes[i] = b;
        }
        return bytes;
    }
}

