/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Environment;
import com.teamdev.jxbrowser.UnsupportedBrowserTypeException;
import com.teamdev.jxbrowser.d;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrowserFactory {
    private static final Logger a = LoggerFactory.getLogger(BrowserFactory.class);
    private static BrowserType b;

    protected abstract Browser create();

    public static Browser createBrowser(BrowserType browserType) {
        Object object;
        if (!browserType.isSupported()) {
            String string = Environment.getInstance().getInfo();
            throw new UnsupportedBrowserTypeException(browserType, browserType + " engine doesn't support current environment: " + string);
        }
        try {
            object = browserType;
            Properties properties = new Properties();
            object = object.getClass().getResourceAsStream("engine.properties");
            properties.load((InputStream)object);
            object = properties.getProperty("browser.factory.class.name");
            object = Class.forName((String)object);
            object = ((Class)object).asSubclass(BrowserFactory.class);
            object = ((Class)object).newInstance();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot create ").append(browserType).append(" Browser instance on ");
            stringBuilder.append(Environment.getInstance().getInfo());
            a.error(stringBuilder.toString(), (Throwable)exception);
            throw new RuntimeException(stringBuilder.toString(), exception);
        }
        return ((BrowserFactory)object).create();
    }

    public static Browser createBrowser() {
        return BrowserFactory.createBrowser(b);
    }

    public static void setDefaultBrowserType(BrowserType browserType) {
        b = browserType;
    }

    public static BrowserType getDefaultBrowserType() {
        return b;
    }

    static {
        d.a().b();
        b = BrowserType.getPlatformSpecificBrowser();
    }
}

