/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMeta
extends HtmlElement {
    private static final long serialVersionUID = 7408601325303605790L;
    public static final String TAG_NAME = "meta";

    HtmlMeta(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if ("set-cookie".equalsIgnoreCase(this.getHttpEquivAttribute())) {
            this.performSetCookie();
        }
    }

    protected void performSetCookie() {
        String[] parts = this.getContentAttribute().split("\\s*;\\s*");
        String name = StringUtils.substringBefore((String)parts[0], (String)"=");
        String value = StringUtils.substringAfter((String)parts[0], (String)"=");
        URL url = this.getPage().getWebResponse().getRequestSettings().getUrl();
        String host = url.getHost();
        boolean secure = "https".equals(url.getProtocol());
        String path = null;
        Date expires = null;
        for (int i = 1; i < parts.length; ++i) {
            String partName = StringUtils.substringBefore((String)parts[i], (String)"=").trim().toLowerCase();
            String partValue = StringUtils.substringAfter((String)parts[i], (String)"=").trim();
            if ("path".equals(partName)) {
                path = partValue;
                continue;
            }
            if ("expires".equals(partName)) {
                expires = com.gargoylesoftware.htmlunit.util.StringUtils.parseHttpDate(partValue);
                continue;
            }
            this.notifyIncorrectness("set-cookie http-equiv meta tag: unknown attribute '" + partName + "'.");
        }
        Cookie cookie = new Cookie(host, name, value, path, expires, secure);
        this.getPage().getWebClient().getCookieManager().addCookie(cookie);
    }

    public final String getHttpEquivAttribute() {
        return this.getAttribute("http-equiv");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getContentAttribute() {
        return this.getAttribute("content");
    }

    public final String getSchemeAttribute() {
        return this.getAttribute("scheme");
    }
}

