/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortKey {
    private final SortOrder sortOrder;
    private final int column;
    private final Comparator comparator;

    public SortKey(SortOrder sortOrder, int column) {
        this(sortOrder, column, null);
    }

    public SortKey(SortOrder sortOrder, int column, Comparator comparator) {
        if (sortOrder == null) {
            throw new IllegalArgumentException();
        }
        if (column < 0) {
            throw new IllegalArgumentException();
        }
        this.column = column;
        this.comparator = comparator;
        this.sortOrder = sortOrder;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public int getColumn() {
        return this.column;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortKey sortKey = (SortKey)o;
        if (this.column != sortKey.column) {
            return false;
        }
        return !(this.sortOrder != null ? !this.sortOrder.equals(sortKey.sortOrder) : sortKey.sortOrder != null);
    }

    public int hashCode() {
        int result = this.sortOrder != null ? this.sortOrder.hashCode() : 0;
        result = 29 * result + this.column;
        return result;
    }

    public static SortKey getFirstSortingKey(List<? extends SortKey> keys) {
        for (SortKey sortKey : keys) {
            if (!sortKey.getSortOrder().isSorted()) continue;
            return sortKey;
        }
        return null;
    }

    public static SortKey getFirstSortKeyForColumn(List<? extends SortKey> keys, int modelColumn) {
        for (SortKey sortKey : keys) {
            if (sortKey.getColumn() != modelColumn) continue;
            return sortKey;
        }
        return null;
    }
}

