/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.Bool;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.hook.CBTHookListener;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.data.CREATESTRUCT;
import com.jniwrapper.win32.ui.Wnd;

public abstract class CBTEvent
extends HookEventObject {
    private final Bool allow;
    static /* synthetic */ Class class$com$jniwrapper$win32$ui$Wnd$ShowWindowCommand;

    public CBTEvent(Object source, Bool allow) {
        super(source);
        this.allow = allow;
    }

    public void setAllow(boolean value) {
        if (this.allow != null) {
            this.allow.setValue(value);
        }
    }

    void dispatch(CBTHookListener listener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SysCommand
    extends CBTEvent {
        private final long sysCommand;
        private final long info;

        public SysCommand(Object source, Bool allow, long sysCommand, long info) {
            super(source, allow);
            this.sysCommand = sysCommand;
            this.info = info;
        }

        public long getSysCommand() {
            return this.sysCommand;
        }

        public long getInfo() {
            return this.info;
        }

        void dispatch(CBTHookListener listener) {
            listener.sysCommand(this);
        }
    }

    public static class SetFocus
    extends CBTEvent {
        private final Wnd windowGainingFocus;
        private final Wnd windowLosingFocus;

        public SetFocus(Object source, Bool allow, Wnd windowGainingFocus, Wnd windowLosingFocus) {
            super(source, allow);
            this.windowGainingFocus = windowGainingFocus;
            this.windowLosingFocus = windowLosingFocus;
        }

        public Wnd getWindowGainingFocus() {
            return this.windowGainingFocus;
        }

        public Wnd getWindowLosingFocus() {
            return this.windowLosingFocus;
        }

        void dispatch(CBTHookListener listener) {
            listener.setFocus(this);
        }
    }

    public static class QS
    extends CBTEvent {
        public QS(Object source) {
            super(source, null);
        }

        void dispatch(CBTHookListener listener) {
            listener.qs(this);
        }
    }

    public static class MoveSize
    extends CBTEvent {
        private final Wnd windowHandle;
        private final Rect rect;

        public MoveSize(Object source, Bool allow, Wnd windowHandle, Rect rect) {
            super(source, allow);
            this.windowHandle = windowHandle;
            this.rect = rect;
        }

        public Wnd getWindowHandle() {
            return this.windowHandle;
        }

        public Rect getWindowRect() {
            return this.rect;
        }

        void dispatch(CBTHookListener listener) {
            listener.moveSize(this);
        }
    }

    public static class MinMax
    extends CBTEvent {
        private final Wnd windowHandle;
        private final long lParam;

        public MinMax(Object source, Bool allow, Wnd windowHandle, long lParam) {
            super(source, allow);
            this.windowHandle = windowHandle;
            this.lParam = lParam;
        }

        public Wnd getWindowHandle() {
            return this.windowHandle;
        }

        public Wnd.ShowWindowCommand getOperation() {
            int operation = (int)(this.lParam & 0xFFFFL);
            return (Wnd.ShowWindowCommand)Enums.getItem((Class)(class$com$jniwrapper$win32$ui$Wnd$ShowWindowCommand == null ? (class$com$jniwrapper$win32$ui$Wnd$ShowWindowCommand = CBTEvent.class$("com.jniwrapper.win32.ui.Wnd$ShowWindowCommand")) : class$com$jniwrapper$win32$ui$Wnd$ShowWindowCommand), (int)operation);
        }

        void dispatch(CBTHookListener listener) {
            listener.minMax(this);
        }
    }

    public static class KeySkipped
    extends CBTEvent {
        private final long virtualKeyCode;
        private final long keyInfo;

        public KeySkipped(Object source, long virtualKeyCode, long keyInfo) {
            super(source, null);
            this.virtualKeyCode = virtualKeyCode;
            this.keyInfo = keyInfo;
        }

        public long getVirtualKeyCode() {
            return this.virtualKeyCode;
        }

        public int getRepeatCount() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return flagSet.getBits(0, 15);
        }

        public int getScanCode() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return flagSet.getBits(16, 23);
        }

        public boolean isExtendedKey() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return flagSet.getBit(24);
        }

        public boolean isAltPressed() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return flagSet.getBit(29);
        }

        public boolean getPreviousState() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return flagSet.getBit(30);
        }

        public boolean getTransitionState() {
            FlagSet flagSet = new FlagSet(this.keyInfo);
            return !flagSet.getBit(31);
        }

        void dispatch(CBTHookListener listener) {
            listener.keySkipped(this);
        }
    }

    public static class DestroyWnd
    extends CBTEvent {
        private final Wnd destroyedWindow;

        public DestroyWnd(Object source, Bool allow, Wnd destroyedWindow) {
            super(source, allow);
            this.destroyedWindow = destroyedWindow;
        }

        public Wnd getDestoyedWindow() {
            return this.destroyedWindow;
        }

        void dispatch(CBTHookListener listener) {
            listener.destroyWnd(this);
        }
    }

    public static class CreateWnd
    extends CBTEvent {
        private final Wnd newWindow;
        private final CREATESTRUCT createstruct;
        private final Wnd insertAfter;

        public CreateWnd(Object source, Bool allow, Wnd newWindow, CREATESTRUCT createstruct, Wnd insertAfter) {
            super(source, allow);
            this.newWindow = newWindow;
            this.createstruct = createstruct;
            this.insertAfter = insertAfter;
        }

        public Wnd getNewWindow() {
            return this.newWindow;
        }

        public CREATESTRUCT getCreatestruct() {
            return this.createstruct;
        }

        public Wnd getInsertAfter() {
            return this.insertAfter;
        }

        void dispatch(CBTHookListener listener) {
            listener.createWnd(this);
        }
    }

    public static class ClickSkipped
    extends CBTEvent {
        private final long mouseMessage;
        private final Point cursorCoordinates;
        private final Wnd window;
        private final long hitTestCode;

        public ClickSkipped(Object source, long mouseMessage, Point point, Wnd window, long hitTestCode) {
            super(source, null);
            this.mouseMessage = mouseMessage;
            this.cursorCoordinates = point;
            this.window = window;
            this.hitTestCode = hitTestCode;
        }

        public long getMouseMessage() {
            return this.mouseMessage;
        }

        public Point getCursorCoordinates() {
            return this.cursorCoordinates;
        }

        public Wnd getWindow() {
            return this.window;
        }

        public long getHitTestCode() {
            return this.hitTestCode;
        }

        void dispatch(CBTHookListener listener) {
            listener.clickSkipped(this);
        }
    }

    public static class Activate
    extends CBTEvent {
        private final Wnd activeWindow;
        private final Wnd activatedWindow;
        private final boolean activatedByMouse;

        public Activate(Object source, Bool allow, Wnd activeWindow, Wnd activatedWindow, boolean activatedByMouse) {
            super(source, allow);
            this.activeWindow = activeWindow;
            this.activatedWindow = activatedWindow;
            this.activatedByMouse = activatedByMouse;
        }

        public Wnd getActiveWindow() {
            return this.activeWindow;
        }

        public Wnd getActivatedWindow() {
            return this.activatedWindow;
        }

        public boolean isActivatedByMouse() {
            return this.activatedByMouse;
        }

        void dispatch(CBTHookListener listener) {
            listener.activate(this);
        }
    }
}

