/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.ui.User32;

abstract class LowLevelHook
extends Hook {
    static final int HC_ACTION = 0;
    static final int CONSUME_ACTION = -1;
    private final Handle _hookHandle = new Handle();
    private MessageLoopThread _dispatchThread = new MessageLoopThread("HookDispatchThread" + this.hashCode());
    private HookProc _callback;

    LowLevelHook(Hook.Descriptor descriptor) {
        super(descriptor);
    }

    public boolean isInstalled() {
        return this._dispatchThread.isStarted();
    }

    public void install() {
        this._dispatchThread.doStart();
        this._callback = new HookProc();
        try {
            this._dispatchThread.doInvokeAndWait(new Runnable(){

                public void run() {
                    User32 user32 = User32.getInstance();
                    Function setWindowsHook = user32.getFunction(new FunctionName("SetWindowsHookEx").toString());
                    UInt32 threadID = new UInt32();
                    Module currentModule = Module.getCurrent();
                    setWindowsHook.invoke((Parameter)LowLevelHook.this._hookHandle, new Parameter[]{new Int((long)LowLevelHook.this.getDescriptor().getValue()), LowLevelHook.this._callback, currentModule, threadID});
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to install low level hook", e);
        }
    }

    public void uninstall() {
        try {
            this._dispatchThread.doInvokeAndWait(new Runnable(){

                public void run() {
                    User32 user32 = User32.getInstance();
                    Function unhook = user32.getFunction("UnhookWindowsHookEx");
                    unhook.invoke(null, (Parameter)LowLevelHook.this._hookHandle);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to uninstall low level hook", e);
        }
        finally {
            this._dispatchThread.doStop();
            this._callback.dispose();
        }
    }

    protected abstract long processEvent(long var1, long var3);

    public void setSynchronous(boolean synchronous) {
    }

    public boolean isSynchronous() {
        return true;
    }

    private class HookProc
    extends Callback {
        private Int code = new Int();
        private Pointer.Void wParam = new Pointer.Void();
        private Pointer.Void lParam = new Pointer.Void();
        private Pointer.Void lResult = new Pointer.Void();
        private Function CallNextHookEx = User32.getInstance().getFunction("CallNextHookEx");

        public HookProc() {
            this.init(new Parameter[]{this.code, this.wParam, this.lParam}, (Parameter)this.lResult);
        }

        public void callback() {
            long nCode = this.code.getValue();
            if (nCode < 0L) {
                this.CallNextHookEx.invoke((Parameter)this.lResult, (Parameter)LowLevelHook.this._hookHandle, (Parameter)this.code, (Parameter)this.wParam, (Parameter)this.lParam);
            } else if (nCode == 0L) {
                long postAction = LowLevelHook.this.processEvent(this.wParam.getValue(), this.lParam.getValue());
                if (postAction == -1L) {
                    this.lResult.setValue(-1L);
                } else {
                    this.CallNextHookEx.invoke((Parameter)this.lResult, (Parameter)LowLevelHook.this._hookHandle, (Parameter)this.code, (Parameter)this.wParam, (Parameter)this.lParam);
                }
            } else {
                this.CallNextHookEx.invoke((Parameter)this.lResult, (Parameter)LowLevelHook.this._hookHandle, (Parameter)this.code, (Parameter)this.wParam, (Parameter)this.lParam);
            }
        }
    }
}

