/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.MemoryStatus;
import com.jniwrapper.win32.system.MemoryStatusEx;

public class MemoryInfo {
    private long memoryLoad;
    private long totalPhys;
    private long availPhys;
    private long totalPageFile;
    private long availPageFile;
    private long totalVirtual;
    private long availVirtual;
    private long availExtendedVirtual;

    public MemoryInfo() {
        try {
            Bool result = new Bool();
            Function globalMemoryStatusEx = Kernel32.getInstance().getFunction("GlobalMemoryStatusEx");
            MemoryStatusEx memoryStatusEx = new MemoryStatusEx();
            long errorCode = globalMemoryStatusEx.invoke((Parameter)result, (Parameter)new Pointer((Parameter)memoryStatusEx));
            if (!result.getValue()) {
                throw new LastErrorException(errorCode);
            }
            this.memoryLoad = memoryStatusEx.getMemoryLoad();
            this.totalPhys = memoryStatusEx.getTotalPhys();
            this.availPhys = memoryStatusEx.getAvailPhys();
            this.totalPageFile = memoryStatusEx.getTotalPageFile();
            this.availPageFile = memoryStatusEx.getAvailPageFile();
            this.totalVirtual = memoryStatusEx.getTotalVirtual();
            this.availVirtual = memoryStatusEx.getAvailVirtual();
            this.availExtendedVirtual = memoryStatusEx.getAvailExtendedVirtual();
        }
        catch (NoSuchFunctionException e) {
            MemoryStatus memoryStatus = new MemoryStatus();
            this.memoryLoad = memoryStatus.getMemoryLoad();
            this.totalPhys = memoryStatus.getTotalPhys();
            this.availPhys = memoryStatus.getAvailPhys();
            this.totalPageFile = memoryStatus.getTotalPageFile();
            this.availPageFile = memoryStatus.getAvailPageFile();
            this.totalVirtual = memoryStatus.getTotalVirtual();
            this.availVirtual = memoryStatus.getAvailVirtual();
            this.availExtendedVirtual = 0L;
        }
    }

    public long getMemoryLoad() {
        return this.memoryLoad;
    }

    public long getTotalPhys() {
        return this.totalPhys;
    }

    public long getAvailPhys() {
        return this.availPhys;
    }

    public long getTotalPageFile() {
        return this.totalPageFile;
    }

    public long getAvailPageFile() {
        return this.availPageFile;
    }

    public long getTotalVirtual() {
        return this.totalVirtual;
    }

    public long getAvailVirtual() {
        return this.availVirtual;
    }

    public long getAvailExtendedVirtual() {
        return this.availExtendedVirtual;
    }
}

