/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.Kernel32;

public class Module
extends Handle {
    private static final FunctionName FUNCTION_GET_MODULE_HANDLE = new FunctionName("GetModuleHandle");
    private static final FunctionName FUNCTION_GET_MODULE_FILE_NAME = new FunctionName("GetModuleFileName");

    private Module() {
    }

    public static Module getCurrent() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GET_MODULE_HANDLE.toString());
        Module hModule = new Module();
        function.invoke((Parameter)hModule, (Parameter)new Handle());
        return hModule;
    }

    public String getFileName() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GET_MODULE_FILE_NAME.toString());
        Str fname = new Str("", 255);
        UInt32 result = new UInt32();
        long errorCode = function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)fname), (Parameter)new UInt32((long)fname.getMaxLength()));
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Unable to get module file name.");
        }
        String fileName = fname.getValue().trim();
        return fileName;
    }
}

