/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Int8;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.LastError;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.FlashInfo;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowMessage;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.WindowPlacement;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.WindowTools;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

public class Wnd
extends Handle {
    private WindowProc _windowProc;
    private WindowMessageListener _windowMessageListener;
    public static final int GW_HWNDFIRST = 0;
    public static final int GW_HWNDLAST = 1;
    public static final int GW_HWNDNEXT = 2;
    public static final int GW_HWNDPREV = 3;
    public static final int GW_OWNER = 4;
    public static final int GW_CHILD = 5;
    private static final FunctionName FUNCTION_FIND_WINDOW = new FunctionName("FindWindow");
    private static final FunctionName FUNCTION_FIND_WINDOW_EX = new FunctionName("FindWindowEx");
    private static final FunctionName FUNCTION_CREATE_WINDOW_EX = new FunctionName("CreateWindowEx");
    private static final FunctionName FUNCTION_GetClassName = new FunctionName("GetClassName");
    private static final String FUNCTION_GET_WINDOW = "GetWindow";
    private static final String FUNCTION_GET_DESKTOP_WINDOW = "GetDesktopWindow";
    private static final String FUNCTION_UPDATE_WINDOW = "UpdateWindow";
    private static final String FUNCTION_DESTROY_WINDOW = "DestroyWindow";
    private static final String FUNCTION_GET_WINDOW_RECT = "GetWindowRect";
    private static final String FUNCTION_GET_CLIENT_RECT = "GetClientRect";
    private static final String FUNCTION_SET_WINDOW_RGN = "SetWindowRgn";
    private static final String FUNCTION_GET_WINDOW_RGN = "GetWindowRgn";
    private static final String FUNCTION_SET_WINDOW_POS = "SetWindowPos";
    private static final String FUNCTION_MOVE_WINDOW = "MoveWindow";
    private static final String FUNCTION_BEGIN_PAINT = "BeginPaint";
    private static final String FUNCTION_END_PAINT = "EndPaint";
    private static final String FUNCTION_SHOW_WINDOW = "ShowWindow";
    private static final FunctionName FUNCTION_SET_WINDOW_LONG = new FunctionName("SetWindowLong");
    private static final FunctionName FUNCTION_GET_WINDOW_LONG = new FunctionName("GetWindowLong");
    private static final String FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES = "SetLayeredWindowAttributes";
    private static final String FUNCTION_GET_LAYERED_WINDOW_ATTRIBUTES = "GetLayeredWindowAttributes";
    private static final String FUNCTION_REDRAW_WINDOW = "RedrawWindow";
    private static final FunctionName FUNCTION_PEEK_MESSAGE = new FunctionName("PeekMessage");
    private static final FunctionName FUNCTION_SEND_MESSAGE = new FunctionName("SendMessage");
    private static final FunctionName FUNCTION_POST_MESSAGE = new FunctionName("PostMessage");
    private static final String FUNCTION_SET_PARENT = "SetParent";
    private static final String FUNCTION_GET_PARENT = "GetParent";
    private static final String FUNCTION_GET_ANCESTOR = "GetAncestor";
    private static final String FUNCTION_BRING_WINDOW_TO_TOP = "BringWindowToTop";
    private static final String FUNCTION_SetForegroundWindow = "SetForegroundWindow";
    private static final FunctionName FUNCTION_CALL_WINDOW_PROC = new FunctionName("CallWindowProc");
    private static final String FUNCTION_GET_UPDATE_RECT = "GetUpdateRect";
    private static final String FUNCTION_InvalidateRect = "InvalidateRect";
    private static final String FUNCTION_FLASH_WINDOW = "FlashWindowEx";
    private static final String FUNCTION_ScreenToClient = "ScreenToClient";
    private static final String FUNCTION_ClientToScreen = "ClientToScreen";
    private static final String FUNCTION_EnumWindows = "EnumWindows";
    private static final String FUNCTION_EnumChildWindows = "EnumChildWindows";
    private static final String FUNCTION_EnumThreadWindows = "EnumThreadWindows";
    private static final FunctionName FUNCTION_GetWindowText = new FunctionName("GetWindowText");
    private static final String FUNCTION_SetFocus = "SetFocus";
    private static final String FUNCTION_GetFocus = "GetFocus";
    private static final String FUNCTION_IsZoomed = "IsZoomed";
    public static final String FUNCTION_GET_WINDOW_THREAD_PROCESS_ID = "GetWindowThreadProcessId";
    private static final String FUNCTION_IsWindow = "IsWindow";
    public static final FunctionName FUNCTION_SetDlgItemText = new FunctionName("SetDlgItemText");
    public static final FunctionName FUNCTION_GetDlgItemText = new FunctionName("GetDlgItemText");
    public static final int WS_OVERLAPPED = 0;
    public static final int WS_POPUP = Integer.MIN_VALUE;
    public static final int WS_CHILD = 0x40000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_VISIBLE = 0x10000000;
    public static final int WS_DISABLED = 0x8000000;
    public static final int WS_CLIPSIBLINGS = 0x4000000;
    public static final int WS_CLIPCHILDREN = 0x2000000;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_CAPTION = 0xC00000;
    public static final int WS_BORDER = 0x800000;
    public static final int WS_DLGFRAME = 0x400000;
    public static final int WS_VSCROLL = 0x200000;
    public static final int WS_HSCROLL = 0x100000;
    public static final int WS_SYSMENU = 524288;
    public static final int WS_THICKFRAME = 262144;
    public static final int WS_GROUP = 131072;
    public static final int WS_TABSTOP = 65536;
    public static final int WS_MINIMIZEBOX = 131072;
    public static final int WS_MAXIMIZEBOX = 65536;
    public static final int WS_OVERLAPPEDWINDOW = 0xCF0000;
    public static final int WS_POPUPWINDOW = -2138570752;
    public static final int WS_CHILDWINDOW = 0x40000000;
    public static final int WS_TILED = 0;
    public static final int WS_ICONIC = 0x20000000;
    public static final int WS_SIZEBOX = 262144;
    public static final int WS_TILEDWINDOW = 0xCF0000;
    public static final int WS_EX_DLGMODALFRAME = 1;
    public static final int WS_EX_NOPARENTNOTIFY = 4;
    public static final int WS_EX_TOPMOST = 8;
    public static final int WS_EX_ACCEPTFILES = 16;
    public static final int WS_EX_TRANSPARENT = 32;
    public static final int WS_EX_MDICHILD = 64;
    public static final int WS_EX_TOOLWINDOW = 128;
    public static final int WS_EX_WINDOWEDGE = 256;
    public static final int WS_EX_CLIENTEDGE = 512;
    public static final int WS_EX_CONTEXTHELP = 1024;
    public static final int WS_EX_RIGHT = 4096;
    public static final int WS_EX_LEFT = 0;
    public static final int WS_EX_RTLREADING = 8192;
    public static final int WS_EX_LTRREADING = 0;
    public static final int WS_EX_LEFTSCROLLBAR = 16384;
    public static final int WS_EX_RIGHTSCROLLBAR = 0;
    public static final int WS_EX_CONTROLPARENT = 65536;
    public static final int WS_EX_STATICEDGE = 131072;
    public static final int WS_EX_APPWINDOW = 262144;
    public static final int WS_EX_OVERLAPPEDWINDOW = 768;
    public static final int WS_EX_PALETTEWINDOW = 392;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_SHOWWINDOW = 64;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOSENDCHANGING = 1024;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_DEFERERASE = 8192;
    public static final int SWP_ASYNCWINDOWPOS = 16384;
    public static final int HWND_TOP = 0;
    public static final int HWND_BOTTOM = 1;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int GWL_WNDPROC = -4;
    public static final int GWL_HINSTANCE = -6;
    public static final int GWL_HWNDPARENT = -8;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int GWL_USERDATA = -21;
    public static final int GWL_ID = -12;
    public static final int RDW_INVALIDATE = 1;
    public static final int RDW_INTERNALPAINT = 2;
    public static final int RDW_ERASE = 4;
    public static final int RDW_VALIDATE = 8;
    public static final int RDW_NOINTERNALPAINT = 16;
    public static final int RDW_NOERASE = 32;
    public static final int RDW_NOCHILDREN = 64;
    public static final int RDW_ALLCHILDREN = 128;
    public static final int RDW_UPDATENOW = 256;
    public static final int RDW_ERASENOW = 512;
    public static final int RDW_FRAME = 1024;
    public static final int RDW_NOFRAME = 2048;
    public static final int OPAQUE = 255;
    public static final int TRANSPARENT = 0;
    static final int DEFAULT_ELLIPSE_HEIGHT = 30;
    static final int DEFAULT_ELLIPSE_WIDTH = 30;

    public Wnd() {
    }

    public Wnd(long value) {
        super(value);
    }

    public Wnd(Component component) {
        this(WindowTools.getWindowHandle(component));
    }

    static Function getFunction(Object functionName) {
        return User32.getInstance().getFunction(functionName.toString());
    }

    public void eventLoop() {
        Wnd.eventLoop(this.getValue());
    }

    public static void eventLoop(long hwnd) {
        if (hwnd == 0L) {
            throw new IllegalArgumentException("Event processing window is not available");
        }
        Function getMessage = Wnd.getFunction(User32.FUNCTION_GET_MESSAGE);
        Function translateMessage = Wnd.getFunction("TranslateMessage");
        Function dispatchMessage = Wnd.getFunction(User32.FUNCTION_DISPATCH_MESSAGE);
        Wnd hWnd = new Wnd(hwnd);
        ShortInt result = new ShortInt(1L);
        Msg msg = new Msg();
        IntPtr nullValue = new IntPtr(0L);
        while (result.getValue() != 0L) {
            Pointer msgPointer = new Pointer((Parameter)msg);
            getMessage.invoke((Parameter)result, (Parameter)msgPointer, (Parameter)hWnd, (Parameter)nullValue, (Parameter)nullValue);
            if (result.getValue() == -1L) break;
            translateMessage.invoke(null, (Parameter)msgPointer);
            dispatchMessage.invoke(null, (Parameter)msgPointer);
        }
    }

    public static Wnd findWindow(String className, String windowName) {
        Function function = Wnd.getFunction(FUNCTION_FIND_WINDOW);
        Wnd result = new Wnd();
        Handle wndName = windowName == null ? new Handle() : new Str(windowName);
        Str cName = new Str(className);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)cName), (Parameter)wndName);
        return result;
    }

    public static Wnd findWindowEx(Wnd parent, String className, String windowName) {
        Function function = Wnd.getFunction(FUNCTION_FIND_WINDOW_EX);
        Wnd result = new Wnd();
        Handle wndName = windowName == null ? new Handle() : new Pointer((Parameter)new Str(windowName));
        Str cName = new Str(className);
        function.invoke((Parameter)result, (Parameter)(parent != null ? parent : new Handle()), (Parameter)new Handle(), (Parameter)new Pointer((Parameter)cName), (Parameter)wndName);
        return result;
    }

    public static Wnd findWindow(String className) {
        return Wnd.findWindow(className, null);
    }

    public static Wnd findWindowByName(String windowName) {
        Function function = Wnd.getFunction(FUNCTION_FIND_WINDOW);
        Wnd result = new Wnd();
        function.invoke((Parameter)result, (Parameter)new Pointer(null, true), (Parameter)new Str(windowName));
        return result;
    }

    public static Wnd getDesktopWindow() {
        Function function = Wnd.getFunction(FUNCTION_GET_DESKTOP_WINDOW);
        Wnd result = new Wnd();
        function.invoke((Parameter)result);
        return result;
    }

    private static Wnd createWindow(Object functionName, Parameter[] parameters) {
        Wnd result = new Wnd();
        Function function = Wnd.getFunction(functionName);
        long errorCode = function.invoke((Parameter)result, parameters);
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Cannot create window.");
        }
        return result;
    }

    public static Wnd createWindow(String className, String windowName, int windowStyle, long x, long y, long nWidth, long nHeight, Wnd hWndParent, Handle hMenu, Handle hInstance, Handle lpParam) {
        return Wnd.createWindow(FUNCTION_CREATE_WINDOW_EX, new Parameter[]{new UInt(0L), new Str(className), new Str(windowName), new Int((long)windowStyle), new Int(x), new Int(y), new Int(nWidth), new Int(nHeight), hWndParent, hMenu, hInstance, lpParam});
    }

    public static Wnd createWindow(int windowStyleEx, String className, String windowName, int windowStyle, long x, long y, long nWidth, long nHeight, Wnd hWndParent, Handle hMenu, Handle hInstance, Handle lpParam) {
        return Wnd.createWindow(FUNCTION_CREATE_WINDOW_EX, new Parameter[]{new Int32(windowStyleEx), new Str(className), new Str(windowName), new Int((long)windowStyle), new Int(x), new Int(y), new Int(nWidth), new Int(nHeight), hWndParent, hMenu, hInstance, lpParam});
    }

    public static Wnd createWindow(String className) {
        Handle NULL = new Handle();
        Wnd parent = new Wnd();
        return Wnd.createWindow(0, className, className, 0, 0L, 0L, 0L, 0L, parent, NULL, NULL, NULL);
    }

    public void update() {
        Function function = Wnd.getFunction(FUNCTION_UPDATE_WINDOW);
        Int result = new Int();
        long errorCode = function.invoke((Parameter)result, (Parameter)this);
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Error updating window.");
        }
    }

    public void destroy() {
        Function function = Wnd.getFunction(FUNCTION_DESTROY_WINDOW);
        Int result = new Int();
        long errorCode = function.invoke((Parameter)result, (Parameter)this);
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Error destroying window.");
        }
    }

    public Size getSize() {
        Size result = new Size();
        Rect bounds = this.getWindowRect();
        result.setCx(bounds.getRightAsInt() - bounds.getLeftAsInt());
        result.setCy(bounds.getBottomAsInt() - bounds.getTopAsInt());
        return result;
    }

    public Size getClientSize() {
        Size result = new Size();
        Rect bounds = this.getClientRect();
        result.setCx(bounds.getRightAsInt() - bounds.getLeftAsInt());
        result.setCy(bounds.getBottomAsInt() - bounds.getTopAsInt());
        return result;
    }

    public Rect getBounds() {
        Rect result = new Rect();
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RECT);
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)result));
        return result;
    }

    public Rect getWindowRect() {
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RECT);
        Rect result = new Rect();
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)result));
        return result;
    }

    public void centerInDesktop() {
        Rect desktop = Wnd.getDesktopWindow().getWindowRect();
        Rect windowRect = this.getWindowRect();
        int left = (desktop.getWidth() - windowRect.getWidth()) / 2;
        int top = (desktop.getHeight() - windowRect.getHeight()) / 2;
        windowRect.moveTo(left, top);
        this.moveWindow((int)windowRect.getLeft(), (int)windowRect.getTop(), windowRect.getWidth(), windowRect.getHeight(), true);
    }

    public Rect getClientRect() {
        Rect result = new Rect();
        Function function = Wnd.getFunction(FUNCTION_GET_CLIENT_RECT);
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)result));
        return result;
    }

    public void setRegion(Region region, boolean redraw) {
        Function function = Wnd.getFunction(FUNCTION_SET_WINDOW_RGN);
        function.invoke(null, (Parameter)this, (Parameter)(region == null ? new Handle() : region), (Parameter)new Bool(redraw));
    }

    public Region getRegion() {
        Region result = new Region();
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RGN);
        function.invoke(null, (Parameter)this, (Parameter)result);
        return result;
    }

    public boolean setPosition(Wnd wndInsertAfter, long x, long y, long cx, long cy, long flags) {
        Function function = Wnd.getFunction(FUNCTION_SET_WINDOW_POS);
        IntBool result = new IntBool();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{this, wndInsertAfter, new Int(x), new Int(y), new Int(cx), new Int(cy), new UInt(flags)});
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Failed to show splash.", true);
        }
        return true;
    }

    public DC beginPaint(PaintStruct paintStruct) {
        Function beginPaint = Wnd.getFunction(FUNCTION_BEGIN_PAINT);
        DC result = new DC();
        long errorCode = beginPaint.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)paintStruct));
        if (result.isNull()) {
            throw new LastErrorException(errorCode, "Failed to get DC.", true);
        }
        return result;
    }

    public void endPaint(PaintStruct paintStruct) {
        Function endPaint = User32.getInstance().getFunction(FUNCTION_END_PAINT);
        endPaint.invoke(null, (Parameter)this, (Parameter)new Pointer.Const((Parameter)paintStruct));
    }

    public boolean sendMessage(int msg, long wParam, long lParam) {
        Function sendMessage = Wnd.getFunction(FUNCTION_SEND_MESSAGE);
        Bool result = new Bool();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)msg), (Parameter)new IntPtr(wParam), (Parameter)new IntPtr(lParam));
        return result.getValue();
    }

    public long sendMessageEx(int msg, long wParam, long lParam) {
        Function sendMessage = Wnd.getFunction(FUNCTION_SEND_MESSAGE);
        IntPtr result = new IntPtr();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)msg), (Parameter)new IntPtr(wParam), (Parameter)new IntPtr(lParam));
        return result.getValue();
    }

    public boolean peekMessage(long msg, boolean remove) {
        return this.peekMessage(new Msg(), msg, msg, remove);
    }

    public boolean peekMessage(Msg msg, long filterMin, long filterMax, boolean remove) {
        Function peekMessage = Wnd.getFunction(FUNCTION_PEEK_MESSAGE);
        Bool result = new Bool();
        peekMessage.invoke((Parameter)result, new Parameter[]{new Pointer((Parameter)msg), this, new UInt(filterMin), new UInt(filterMax), new UInt(remove ? 1L : 0L)});
        return result.getValue();
    }

    public boolean postMessage(int msg, long wParam, long lParam) {
        Function sendMessage = Wnd.getFunction(FUNCTION_POST_MESSAGE);
        IntBool result = new IntBool();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)msg), (Parameter)new IntPtr(wParam), (Parameter)new IntPtr(lParam));
        return result.getBooleanValue();
    }

    public void show(ShowWindowCommand command) {
        Function show = Wnd.getFunction(FUNCTION_SHOW_WINDOW);
        show.invoke(null, (Parameter)this, (Parameter)new Int((long)command.getValue()));
    }

    public void setWindowLong(int nIndex, long dwNewLong) {
        this.setWindowLong(nIndex, (Parameter)new IntPtr(dwNewLong));
    }

    public long setWindowLong(int nIndex, Parameter newValue) {
        UInt result = new UInt();
        Function setWindowLong = Wnd.getFunction(FUNCTION_SET_WINDOW_LONG);
        LastError.setValue(0);
        long errorCode = setWindowLong.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)nIndex), newValue);
        if (result.getValue() == 0L && errorCode != 0L) {
            throw new LastErrorException(errorCode);
        }
        return result.getValue();
    }

    public long getWindowLong(int nIndex) {
        IntPtr result = new IntPtr();
        Function getWindowLong = Wnd.getFunction(FUNCTION_GET_WINDOW_LONG);
        LastError.setValue(0);
        long errorCode = getWindowLong.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)nIndex));
        return result.getValue();
    }

    public void setLayeredWindowAttributes(ColorRef crKey, byte bAlpha, int dwFlags) {
        Function setLayeredWindowAttr = Wnd.getFunction(FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES);
        setLayeredWindowAttr.invoke(null, (Parameter)this, (Parameter)(crKey == null ? new ColorRef(0L) : crKey), (Parameter)new Int8(bAlpha), (Parameter)new UInt32((long)dwFlags));
    }

    public boolean getLayeredWindowAttributes(ColorRef crKey, Int8 bAlpha, UInt32 dwFlags) {
        Function getLayeredWindowAttr = Wnd.getFunction(FUNCTION_GET_LAYERED_WINDOW_ATTRIBUTES);
        Int32 res = new Int32();
        getLayeredWindowAttr.invoke((Parameter)res, (Parameter)this, (Parameter)(crKey == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)crKey)), (Parameter)(bAlpha == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)bAlpha)), (Parameter)(dwFlags == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)dwFlags)));
        return res.getValue() != 0L;
    }

    public void redraw(Rect updateRect, Region updateRegion, int flags) {
        Function redrawWindow = Wnd.getFunction(FUNCTION_REDRAW_WINDOW);
        redrawWindow.invoke(null, (Parameter)this, (Parameter)new Pointer((Parameter)updateRect, updateRect == null), (Parameter)(updateRegion == null ? new Region() : updateRegion), (Parameter)new UInt((long)flags));
    }

    public void setParent(Wnd parent) {
        Function setParent = Wnd.getFunction(FUNCTION_SET_PARENT);
        Wnd previousParent = new Wnd();
        LastError.clearLastErrorCode();
        long lastError = setParent.invoke((Parameter)previousParent, (Parameter)this, (Parameter)parent);
        if (previousParent.isNull() && lastError != 0L) {
            throw new LastErrorException(lastError);
        }
    }

    public Wnd getParent() {
        Function getParent = Wnd.getFunction(FUNCTION_GET_PARENT);
        Wnd result = new Wnd();
        getParent.invoke((Parameter)result, (Parameter)this);
        return result;
    }

    public Wnd getAncestor(Ancestor ancestor) {
        Function getParent = Wnd.getFunction(FUNCTION_GET_ANCESTOR);
        Wnd result = new Wnd();
        getParent.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)ancestor.getValue()));
        return result;
    }

    public void bringToTop() {
        Function function = Wnd.getFunction(FUNCTION_BRING_WINDOW_TO_TOP);
        function.invoke(null, (Parameter)this);
    }

    public void setForeground() {
        Function function = Wnd.getFunction(FUNCTION_SetForegroundWindow);
        function.invoke(null, (Parameter)this);
    }

    public static long callWindowProc(Handle wndProc, Wnd wnd, UInt msg, Pointer.Void wParam, Pointer.Void lParam) {
        Function function = Wnd.getFunction(FUNCTION_CALL_WINDOW_PROC);
        IntPtr result = new IntPtr();
        function.invoke((Parameter)result, new Parameter[]{wndProc, wnd, msg, wParam, lParam});
        return result.getValue();
    }

    public void moveWindow(int x, int y, int width, int height, boolean repaint) {
        Function function = Wnd.getFunction(FUNCTION_MOVE_WINDOW);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new Int((long)x), new Int((long)y), new Int((long)width), new Int((long)height), new Bool(repaint)});
    }

    public void moveWindow(int x, int y, int width, int height) {
        this.moveWindow(x, y, width, height, false);
    }

    public boolean getUpdateRect(Rect rect, boolean erase) {
        Function function = Wnd.getFunction(FUNCTION_GET_UPDATE_RECT);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)rect), (Parameter)new Bool(erase));
        return result.getValue();
    }

    public boolean getUpdateRect(Rect rect) {
        return this.getUpdateRect(rect, false);
    }

    public boolean flashWindow(FlashInfo flashInfo) {
        Function function = Wnd.getFunction(FUNCTION_FLASH_WINDOW);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)flashInfo));
        return result.getValue();
    }

    public String getWindowClassName() {
        Str className = new Str();
        Function function = User32.getInstance().getFunction(FUNCTION_GetClassName.toString());
        function.invoke(null, (Parameter)this, (Parameter)className, (Parameter)new Int((long)className.getMaxLength()));
        return className.getValue();
    }

    public Wnd getWindow(int uCmd) {
        Wnd result = new Wnd();
        User32.getInstance().getFunction(FUNCTION_GET_WINDOW).invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)uCmd));
        return result;
    }

    public Object clone() {
        return new Wnd(this.getValue());
    }

    public Point screenToClient(Point point) {
        Function function = User32.getInstance().getFunction(FUNCTION_ScreenToClient);
        Bool result = new Bool();
        Point resultPoint = new Point(point);
        long errorCode = function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)resultPoint));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode);
        }
        return resultPoint;
    }

    public Point clientToScreen(Point point) {
        Function function = User32.getInstance().getFunction(FUNCTION_ClientToScreen);
        Bool result = new Bool();
        Point resultPoint = new Point(point);
        long errorCode = function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)resultPoint));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode);
        }
        return resultPoint;
    }

    public static List getAllWindows() {
        IntBool result = new IntBool();
        IntPtr lParam = new IntPtr();
        EnumWindowsCallback callback = new EnumWindowsCallback();
        Function enumWindows = User32.getInstance().getFunction(FUNCTION_EnumWindows);
        enumWindows.invoke((Parameter)result, (Parameter)callback, (Parameter)lParam);
        callback.dispose();
        return callback.getWindows();
    }

    public static List getChildWindows(Wnd parent) {
        IntBool result = new IntBool();
        IntPtr lParam = new IntPtr();
        EnumWindowsCallback callback = new EnumWindowsCallback();
        Function enumChildWindows = User32.getInstance().getFunction(FUNCTION_EnumChildWindows);
        enumChildWindows.invoke((Parameter)result, (Parameter)parent, (Parameter)callback, (Parameter)lParam);
        callback.dispose();
        return callback.getWindows();
    }

    public List getChildWindows() {
        return Wnd.getChildWindows(this);
    }

    public static List getThreadWindows(long threadID) {
        IntBool result = new IntBool();
        IntPtr lParam = new IntPtr();
        EnumWindowsCallback callback = new EnumWindowsCallback();
        Function enumChildWindows = User32.getInstance().getFunction(FUNCTION_EnumThreadWindows);
        enumChildWindows.invoke((Parameter)result, (Parameter)new UInt32(threadID), (Parameter)callback, (Parameter)lParam);
        callback.dispose();
        return callback.getWindows();
    }

    public String getWindowText() {
        Function function = User32.getInstance().getFunction(FUNCTION_GetWindowText.toString());
        Str text = new Str(1024);
        Int resultLength = new Int();
        function.invoke((Parameter)resultLength, (Parameter)this, (Parameter)new Pointer((Parameter)text), (Parameter)new Int(1024L));
        return text.getValue();
    }

    public void setVisible(boolean visible) {
        long windowStyle = this.getWindowLong(-16);
        windowStyle = !visible ? (windowStyle &= 0xFFFFFFFFEFFFFFFFL) : (windowStyle |= 0x10000000L);
        this.setWindowLong(-16, windowStyle);
    }

    public boolean isVisible() {
        long windowStyle = this.getWindowLong(-16);
        return (windowStyle & 0x10000000L) != 0L;
    }

    public void setWindowStyle(long flags) {
        this.setWindowLong(-16, flags);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowStyle() {
        return this.getWindowLong(-16);
    }

    public void setWindowExStyle(long flags) {
        this.setWindowLong(-20, flags);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowExStyle() {
        return this.getWindowLong(-20);
    }

    public boolean isTransparent() {
        long windowStyle = this.getWindowExStyle();
        return (windowStyle & 0x80000L) != 0L;
    }

    public void setTransparent(boolean transparent) {
        long oldWindowStyle = this.getWindowExStyle();
        if (transparent) {
            long newWindowStyle = oldWindowStyle | 0x80000L;
            this.setWindowExStyle(newWindowStyle);
            this.setLayeredWindowAttributes(new ColorRef(0L), this.getTransparency(), 2);
        } else {
            long newWindowStyle = oldWindowStyle & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(newWindowStyle);
        }
        this.redraw(null, null, 288);
    }

    public void setTransparent(byte transparency) {
        long oldWindowStyle = this.getWindowExStyle();
        if (transparency != 0) {
            long newWindowStyle = oldWindowStyle | 0x80000L;
            this.setWindowExStyle(newWindowStyle);
            this.setLayeredWindowAttributes(new ColorRef(0L), transparency, 2);
        } else {
            long newWindowStyle = oldWindowStyle & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(newWindowStyle);
        }
        this.redraw(null, null, 288);
    }

    public byte getTransparency() {
        Int8 alpha = new Int8();
        this.getLayeredWindowAttributes(null, alpha, null);
        return (byte)alpha.getValue();
    }

    public void setTransparency(byte transparency) {
        this.setLayeredWindowAttributes(null, transparency, 2);
    }

    public boolean isPalleteWindow() {
        long windowStyle = this.getWindowExStyle();
        return (windowStyle & 0x188L) != 0L;
    }

    public void setPalleteWindow(boolean palleteWindow) {
        long oldWindowStyle = this.getWindowExStyle();
        long newWindowStyle = palleteWindow ? oldWindowStyle | 0x188L : oldWindowStyle & 0xFFFFFFFFFFFFFE77L;
        this.setWindowExStyle(newWindowStyle);
        this.redraw(null, null, 1025);
    }

    public void setTopmost(boolean topmost) {
        int zOrder = -2;
        if (topmost) {
            zOrder = -1;
        }
        this.setPosition(new Wnd(zOrder), 0L, 0L, 0L, 0L, 3L);
    }

    public void setRounded(boolean rounded, int ellipseWidth, int ellipseHeight) {
        Region region = null;
        if (rounded) {
            Rect windowRect = this.getWindowRect();
            windowRect.moveTo(0L, 0L);
            region = Region.createRoundRectRegion((int)windowRect.getLeft(), (int)windowRect.getTop(), (int)windowRect.getRight(), (int)windowRect.getBottom(), ellipseWidth, ellipseHeight);
        }
        this.setRegion(region, true);
    }

    public void setRounded(boolean rounded) {
        this.setRounded(rounded, 30, 30);
    }

    public void setWindowIcon(Icon icon, Icon.IconType iconType) {
        this.sendMessageEx(128, iconType.getValue(), icon.getValue());
    }

    public void setCaptionVisible(boolean value) {
        long oldWindowStyle = this.getWindowStyle();
        long newWindowStyle = value ? oldWindowStyle | 0xC00000L : oldWindowStyle & 0xFFFFFFFFFF3FFFFFL;
        this.setWindowStyle(newWindowStyle);
        this.redraw(null, null, 6);
    }

    public boolean isCaptionVisible() {
        long windowStyle = this.getWindowStyle();
        return (windowStyle & 0xC00000L) != 0L;
    }

    public void setBorderVisible(boolean value) {
        long oldWindowStyle = this.getWindowStyle();
        long newWindowStyle = value ? oldWindowStyle | 0x800000L : oldWindowStyle & 0xFFFFFFFFFFFBFFFFL;
        this.setWindowStyle(newWindowStyle);
    }

    public boolean isBorderVisible() {
        long windowStyle = this.getWindowStyle();
        return (windowStyle & 0x800000L) != 0L;
    }

    public Region setRegion(Region region) {
        Region prevRegion = this.getRegion();
        this.setRegion(region, true);
        return prevRegion;
    }

    public void setContinuousRepainting(boolean value) {
        WindowMessageListener windowMessageListener = this.getWindowMessageListener();
        WindowProc windowProc = this.getWindowProc();
        if (value) {
            windowProc.addMessageListener(windowMessageListener);
            windowProc.substitute();
        } else {
            windowProc.removeMessageListener(windowMessageListener);
            windowProc.restoreNative();
        }
    }

    private WindowProc getWindowProc() {
        if (this._windowProc == null) {
            this._windowProc = new WindowProc(this);
        }
        return this._windowProc;
    }

    private WindowMessageListener getWindowMessageListener() {
        if (this._windowMessageListener == null) {
            this._windowMessageListener = new WindowMessageListener(){

                public boolean canHandle(WindowMessage message, boolean beforeWindowProc) {
                    return message.getMsg() == 5 && beforeWindowProc;
                }

                public int handle(WindowMessage message) {
                    Wnd.this.sendMessageEx(562, 0L, 0L);
                    return 0;
                }
            };
        }
        return this._windowMessageListener;
    }

    public Wnd setFocus() {
        Function function = User32.getInstance().getFunction(FUNCTION_SetFocus);
        Wnd previouslyFocusedWindow = new Wnd();
        function.invoke((Parameter)previouslyFocusedWindow, (Parameter)this);
        return previouslyFocusedWindow;
    }

    public static Wnd getFocus() {
        Function function = User32.getInstance().getFunction(FUNCTION_GetFocus);
        Wnd focusedWindow = new Wnd();
        function.invoke((Parameter)focusedWindow);
        return focusedWindow;
    }

    public int getThreadId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 result = new UInt32();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Handle());
        return (int)result.getValue();
    }

    public int getProcessId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 result = new UInt32();
        UInt32 processID = new UInt32();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)processID));
        return (int)processID.getValue();
    }

    public void invalidateRect(Rect rect, boolean erase) {
        Function function = User32.getInstance().getFunction(FUNCTION_InvalidateRect);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)rect, rect == null), (Parameter)new Bool(erase));
    }

    public void setHotKey(HotKey hotKey) {
        long wparam = (long)(hotKey.getKeyCode() & 0xFF) | (hotKey.getFlags() & 0xFFL) * 256L;
        long res = this.sendMessageEx(50, wparam, 0L);
        if (res <= 0L) {
            throw new RuntimeException("The window handle or hot key is invalid.");
        }
    }

    public HotKey getHotKey() {
        long res = this.sendMessageEx(51, 0L, 0L);
        if (res == 0L) {
            return null;
        }
        long lowWord = res & 0xFFL;
        long hiWord = res >> 8;
        HotKey key = new HotKey((int)lowWord);
        key.setupFlag(hiWord, true);
        return key;
    }

    public boolean isWindow() {
        Function isWindowFunction = User32.getInstance().getFunction(FUNCTION_IsWindow);
        Bool result = new Bool();
        isWindowFunction.invoke((Parameter)result, (Parameter)this);
        return result.getValue();
    }

    public static Wnd getForegroundWindow() {
        Wnd wnd = new Wnd();
        Function getForegroundWindow = User32.getInstance().getFunction("GetForegroundWindow");
        getForegroundWindow.invoke((Parameter)wnd);
        return wnd;
    }

    public static Wnd getWindowFromPoint(int x, int y) {
        Wnd wnd = new Wnd();
        Function getWindowFromPoint = User32.getInstance().getFunction("WindowFromPoint");
        getWindowFromPoint.invoke((Parameter)wnd, (Parameter)new Point(x, y));
        return wnd;
    }

    public boolean isMaximized() {
        Function isWindowFunction = User32.getInstance().getFunction(FUNCTION_IsZoomed);
        Bool result = new Bool();
        isWindowFunction.invoke((Parameter)result, (Parameter)this);
        return result.getValue();
    }

    public boolean isMinimized() {
        Function isIconic = User32.getInstance().getFunction("IsIconic");
        Bool result = new Bool();
        isIconic.invoke((Parameter)result, (Parameter)this);
        return result.getValue();
    }

    public WindowPlacement getWindowPlacement() {
        Function getWindowPlacement = User32.getInstance().getFunction("GetWindowPlacement");
        Bool result = new Bool();
        WindowPlacement placement = new WindowPlacement();
        long errorCode = getWindowPlacement.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)placement));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to get window placement");
        }
        return placement;
    }

    public void setWindowPlacement(WindowPlacement placement) {
        Function getWindowPlacement = User32.getInstance().getFunction("SetWindowPlacement");
        Bool result = new Bool();
        long errorCode = getWindowPlacement.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)placement));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to get window placement");
        }
    }

    public long sendMessage(int msg, Parameter wParam, Parameter lParam) {
        Function sendMessage = User32.getInstance().getFunction(FUNCTION_SEND_MESSAGE.toString());
        IntPtr result = new IntPtr();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)msg), (Parameter)(wParam != null ? wParam : new IntPtr()), (Parameter)(lParam != null ? lParam : new IntPtr()));
        return result.getValue();
    }

    public boolean setDlgItemText(int idDlgItem, String string) {
        Function sendMessage = User32.getInstance().getFunction(FUNCTION_SetDlgItemText.toString());
        Bool result = new Bool();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)idDlgItem), (Parameter)new Pointer((Parameter)new Str(string)));
        return result.getValue();
    }

    public String getDlgItemText(int idDlgItem) {
        Function sendMessage = User32.getInstance().getFunction(FUNCTION_GetDlgItemText.toString());
        int maxCount = 512;
        Bool result = new Bool();
        Str resultString = new Str(512);
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)idDlgItem), (Parameter)new Pointer((Parameter)resultString), (Parameter)new Int(512L));
        return resultString.getValue();
    }

    public boolean enableWindow(boolean enable) {
        Function enableWindow = User32.getInstance().getFunction("EnableWindow");
        Bool result = new Bool();
        enableWindow.invoke((Parameter)result, (Parameter)this, (Parameter)new Bool(enable));
        return result.getValue();
    }

    public static class HotKey
    extends FlagSet {
        private static final int MOD_ALT = 1;
        private static final int MOD_CONTROL = 2;
        private static final int MOD_SHIFT = 4;
        private int _keyCode;

        public HotKey(int keyCode) {
            this._keyCode = keyCode;
        }

        public void setAlt(boolean set) {
            this.setupFlag(1L, set);
        }

        public boolean isAlt() {
            return this.contains(1L);
        }

        public void setControl(boolean set) {
            this.setupFlag(2L, set);
        }

        public boolean isControl() {
            return this.contains(2L);
        }

        public void setShift(boolean set) {
            this.setupFlag(4L, set);
        }

        public boolean isShift() {
            return this.contains(4L);
        }

        public int getKeyCode() {
            return this._keyCode;
        }
    }

    private static class EnumWindowsCallback
    extends Callback {
        private Wnd _hwnd = new Wnd();
        private IntPtr _parameter = new IntPtr();
        private Bool _returnVal = new Bool();
        private List _windows = new LinkedList();

        public EnumWindowsCallback() {
            this.init(new Parameter[]{this._hwnd, this._parameter}, (Parameter)this._returnVal);
        }

        public void callback() {
            this._windows.add(new Wnd(this._hwnd.getValue()));
            this._returnVal.setValue(true);
        }

        public List getWindows() {
            return this._windows;
        }
    }

    public static class Ancestor
    extends EnumItem {
        public static Ancestor Parent = new Ancestor(1);
        public static Ancestor Root = new Ancestor(2);
        public static Ancestor RootOwner = new Ancestor(3);

        private Ancestor(int value) {
            super(value);
        }
    }

    public static class ShowWindowCommand
    extends EnumItem {
        public static final ShowWindowCommand HIDE = new ShowWindowCommand(0);
        public static final ShowWindowCommand SHOWNORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand NORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand SHOWMINIMIZED = new ShowWindowCommand(2);
        public static final ShowWindowCommand SHOWMAXIMIZED = new ShowWindowCommand(3);
        public static final ShowWindowCommand MAXIMIZE = new ShowWindowCommand(3);
        public static final ShowWindowCommand SHOWNOACTIVATE = new ShowWindowCommand(4);
        public static final ShowWindowCommand SHOW = new ShowWindowCommand(5);
        public static final ShowWindowCommand MINIMIZE = new ShowWindowCommand(6);
        public static final ShowWindowCommand SHOWMINNOACTIVE = new ShowWindowCommand(7);
        public static final ShowWindowCommand SHOWNA = new ShowWindowCommand(8);
        public static final ShowWindowCommand RESTORE = new ShowWindowCommand(9);
        public static final ShowWindowCommand SHOWDEFAULT = new ShowWindowCommand(10);
        public static final ShowWindowCommand FORCEMINIMIZE = new ShowWindowCommand(11);
        public static final ShowWindowCommand MAX = new ShowWindowCommand(11);

        protected ShowWindowCommand(int value) {
            super(value);
        }
    }
}

