/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.tidy.EncodingNameMapper;
import org.w3c.tidy.ParseProperty;
import org.w3c.tidy.ParsePropertyImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Configuration
implements Serializable {
    public static final int RAW = 0;
    public static final int ASCII = 1;
    public static final int LATIN1 = 2;
    public static final int UTF8 = 3;
    public static final int ISO2022 = 4;
    public static final int MACROMAN = 5;
    public static final int UTF16LE = 6;
    public static final int UTF16BE = 7;
    public static final int UTF16 = 8;
    public static final int WIN1252 = 9;
    public static final int BIG5 = 10;
    public static final int SHIFTJIS = 11;
    private final String[] ENCODING_NAMES = new String[]{"raw", "ASCII", "ISO8859_1", "UTF8", "JIS", "MacRoman", "UnicodeLittle", "UnicodeBig", "Unicode", "Cp1252", "Big5", "SJIS"};
    public static final int DOCTYPE_OMIT = 0;
    public static final int DOCTYPE_AUTO = 1;
    public static final int DOCTYPE_STRICT = 2;
    public static final int DOCTYPE_LOOSE = 3;
    public static final int DOCTYPE_USER = 4;
    public static final int KEEP_LAST = 0;
    public static final int KEEP_FIRST = 1;
    private static final Map<String, Flag> OPTIONS = new HashMap<String, Flag>();
    private static final long serialVersionUID = -4955155037138560842L;
    private int spaces = 2;
    private int wraplen = 68;
    private int tabsize = 8;
    private int docTypeMode = 1;
    private int duplicateAttrs = 0;
    private String altText;
    protected String slidestyle;
    private String language;
    private String docTypeStr;
    private String errfile;
    private boolean writeback;
    private boolean onlyErrors;
    private boolean showWarnings = true;
    private boolean quiet;
    private boolean indentContent;
    private boolean smartIndent;
    private boolean hideEndTags;
    private boolean xmlTags;
    private boolean xmlOut;
    private boolean xHTML;
    private boolean htmlOut;
    private boolean xmlPi;
    private boolean upperCaseTags;
    private boolean upperCaseAttrs;
    private boolean makeClean;
    private boolean makeBare;
    private boolean logicalEmphasis;
    private boolean dropFontTags;
    private boolean dropProprietaryAttributes;
    private boolean dropEmptyParas = true;
    private boolean fixComments = true;
    private boolean trimEmpty = true;
    private boolean breakBeforeBR;
    private boolean burstSlides;
    private boolean numEntities;
    private boolean quoteMarks;
    private boolean quoteNbsp = true;
    private boolean quoteAmpersand = true;
    private boolean wrapAttVals;
    private boolean wrapScriptlets;
    private boolean wrapSection = true;
    private boolean wrapAsp = true;
    private boolean wrapJste = true;
    private boolean wrapPhp = true;
    private boolean fixBackslash = true;
    private boolean indentAttributes;
    private boolean xmlPIs;
    private boolean xmlSpace;
    private boolean encloseBodyText;
    private boolean encloseBlockText;
    private boolean keepFileTimes = true;
    private boolean word2000;
    private boolean tidyMark = true;
    private boolean emacs;
    private boolean literalAttribs;
    private boolean bodyOnly;
    private boolean fixUri = true;
    private boolean lowerLiterals = true;
    private boolean replaceColor;
    private boolean hideComments;
    private boolean indentCdata;
    private boolean forceOutput;
    private int showErrors = 6;
    private boolean asciiChars = true;
    private boolean joinClasses;
    private boolean joinStyles = true;
    private boolean escapeCdata = true;
    private boolean ncr = true;
    private String cssPrefix;
    private String replacementCharEncoding = "WIN1252";
    protected TagTable tt;
    protected Report report;
    private int definedTags;
    private char[] newline = System.getProperty("line.separator").toCharArray();
    private String inCharEncoding = "ISO8859_1";
    private String outCharEncoding = "ASCII";
    private boolean rawOut;
    private int accessibilityCheckLevel = 0;
    private transient Properties properties = new Properties();

    protected Configuration(Report report) {
        this.report = report;
    }

    private static void addConfigOption(Flag flag) {
        OPTIONS.put(flag.getName(), flag);
    }

    public void addProps(Properties p) {
        Enumeration<?> propEnum = p.propertyNames();
        while (propEnum.hasMoreElements()) {
            String key = (String)propEnum.nextElement();
            String value = p.getProperty(key);
            this.properties.put(key, value);
        }
        this.parseProps();
    }

    public void parseFile(String filename) {
        try {
            this.properties.load(new FileInputStream(filename));
        }
        catch (IOException e) {
            System.err.println(filename + " " + e.toString());
            return;
        }
        this.parseProps();
    }

    public static boolean isKnownOption(String name) {
        return name != null && OPTIONS.containsKey(name);
    }

    private void parseProps() {
        for (Object o : this.properties.keySet()) {
            String key = (String)o;
            Flag flag = OPTIONS.get(key);
            if (flag == null) {
                this.report.unknownOption(key);
                continue;
            }
            String stringValue = this.properties.getProperty(key);
            Object value = flag.getParser().parse(stringValue, key, this);
            if (flag.getLocation() == null) continue;
            try {
                flag.getLocation().set(this, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("IllegalArgumentException during config initialization for field " + key + "with value [" + value + "]: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("IllegalArgumentException during config initialization for field " + key + "with value [" + value + "]: " + e.getMessage());
            }
        }
    }

    public void adjust() {
        if (this.encloseBlockText) {
            this.encloseBodyText = true;
        }
        if (this.smartIndent) {
            this.indentContent = true;
        }
        if (this.wraplen == 0) {
            this.wraplen = Integer.MAX_VALUE;
        }
        if (this.word2000) {
            this.definedTags |= 2;
            this.tt.defineTag((short)2, "o:p");
        }
        if (this.xmlTags) {
            this.xHTML = false;
        }
        if (this.xHTML) {
            this.xmlOut = true;
            this.upperCaseTags = false;
            this.upperCaseAttrs = false;
        }
        if (this.xmlTags) {
            this.xmlOut = true;
            this.xmlPIs = true;
        }
        if (!"UTF8".equals(this.getOutCharEncodingName()) && !"ASCII".equals(this.getOutCharEncodingName()) && this.xmlOut) {
            this.xmlPi = true;
        }
        if (this.xmlOut) {
            this.quoteAmpersand = true;
            this.hideEndTags = false;
        }
    }

    public void printConfigOptions(Writer errout, boolean showActualConfiguration) {
        String pad = "                                                                               ";
        try {
            errout.write("\nConfiguration File Settings:\n\n");
            if (showActualConfiguration) {
                errout.write("Name                        Type       Current Value\n");
            } else {
                errout.write("Name                        Type       Allowable values\n");
            }
            errout.write("=========================== =========  ========================================\n");
            ArrayList<Flag> values = new ArrayList<Flag>(OPTIONS.values());
            Collections.sort(values);
            for (Flag configItem : values) {
                errout.write(configItem.getName());
                errout.write(pad, 0, 28 - configItem.getName().length());
                errout.write(configItem.getParser().getType());
                errout.write(pad, 0, 11 - configItem.getParser().getType().length());
                if (showActualConfiguration) {
                    Field field = configItem.getLocation();
                    Object actualValue = null;
                    if (field != null) {
                        try {
                            actualValue = field.get(this);
                        }
                        catch (IllegalArgumentException e1) {
                            throw new RuntimeException("IllegalArgument when reading field " + field.getName());
                        }
                        catch (IllegalAccessException e1) {
                            throw new RuntimeException("IllegalAccess when reading field " + field.getName());
                        }
                    }
                    errout.write(configItem.getParser().getFriendlyName(configItem.getName(), actualValue, this));
                } else {
                    errout.write(configItem.getParser().getOptionValues());
                }
                errout.write("\n");
            }
            errout.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected String getInCharEncodingName() {
        return this.inCharEncoding;
    }

    protected void setInCharEncodingName(String encoding) {
        String javaEncoding = EncodingNameMapper.toJava(encoding);
        if (javaEncoding != null) {
            this.inCharEncoding = javaEncoding;
        }
    }

    protected String getOutCharEncodingName() {
        return this.outCharEncoding;
    }

    protected void setOutCharEncodingName(String encoding) {
        String javaEncoding = EncodingNameMapper.toJava(encoding);
        if (javaEncoding != null) {
            this.outCharEncoding = javaEncoding;
        }
    }

    protected void setInOutEncodingName(String encoding) {
        this.setInCharEncodingName(encoding);
        this.setOutCharEncodingName(encoding);
    }

    protected void setOutCharEncoding(int encoding) {
        this.setOutCharEncodingName(this.convertCharEncoding(encoding));
    }

    protected void setInCharEncoding(int encoding) {
        this.setInCharEncodingName(this.convertCharEncoding(encoding));
    }

    protected String convertCharEncoding(int code) {
        if (code != 0 && code < this.ENCODING_NAMES.length) {
            return this.ENCODING_NAMES[code];
        }
        return null;
    }

    protected void setSpaces(int spaces) {
        this.spaces = spaces;
    }

    protected int getSpaces() {
        return this.spaces;
    }

    protected void setWraplen(int wraplen) {
        this.wraplen = wraplen;
    }

    protected int getWraplen() {
        return this.wraplen;
    }

    protected void setTabsize(int tabsize) {
        this.tabsize = tabsize;
    }

    protected int getTabsize() {
        return this.tabsize;
    }

    protected void setDocTypeMode(int docTypeMode) {
        this.docTypeMode = docTypeMode;
    }

    protected int getDocTypeMode() {
        return this.docTypeMode;
    }

    protected void setDuplicateAttrs(int duplicateAttrs) {
        this.duplicateAttrs = duplicateAttrs;
    }

    protected int getDuplicateAttrs() {
        return this.duplicateAttrs;
    }

    protected void setAltText(String altText) {
        this.altText = altText;
    }

    protected String getAltText() {
        return this.altText;
    }

    protected void setLanguage(String language) {
        this.language = language;
    }

    protected String getLanguage() {
        return this.language;
    }

    protected void setDocTypeStr(String docTypeStr) {
        this.docTypeStr = docTypeStr;
    }

    protected String getDocTypeStr() {
        return this.docTypeStr;
    }

    protected void setErrfile(String errfile) {
        this.errfile = errfile;
    }

    protected String getErrfile() {
        return this.errfile;
    }

    protected void setWriteback(boolean writeback) {
        this.writeback = writeback;
    }

    protected boolean isWriteback() {
        return this.writeback;
    }

    protected void setOnlyErrors(boolean onlyErrors) {
        this.onlyErrors = onlyErrors;
    }

    protected boolean isOnlyErrors() {
        return this.onlyErrors;
    }

    protected void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    protected boolean isShowWarnings() {
        return this.showWarnings;
    }

    protected void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    protected boolean isQuiet() {
        return this.quiet;
    }

    protected void setIndentContent(boolean indentContent) {
        this.indentContent = indentContent;
    }

    protected boolean isIndentContent() {
        return this.indentContent;
    }

    protected void setSmartIndent(boolean smartIndent) {
        this.smartIndent = smartIndent;
    }

    protected boolean isSmartIndent() {
        return this.smartIndent;
    }

    protected void setHideEndTags(boolean hideEndTags) {
        this.hideEndTags = hideEndTags;
    }

    protected boolean isHideEndTags() {
        return this.hideEndTags;
    }

    protected void setXmlTags(boolean xmlTags) {
        this.xmlTags = xmlTags;
    }

    protected boolean isXmlTags() {
        return this.xmlTags;
    }

    protected void setXmlOut(boolean xmlOut) {
        this.xmlOut = xmlOut;
    }

    protected boolean isXmlOut() {
        return this.xmlOut;
    }

    protected void setXHTML(boolean xHTML) {
        this.xHTML = xHTML;
    }

    protected boolean isXHTML() {
        return this.xHTML;
    }

    protected void setHtmlOut(boolean htmlOut) {
        this.htmlOut = htmlOut;
    }

    protected boolean isHtmlOut() {
        return this.htmlOut;
    }

    protected void setXmlPi(boolean xmlPi) {
        this.xmlPi = xmlPi;
    }

    protected boolean isXmlPi() {
        return this.xmlPi;
    }

    protected void setUpperCaseTags(boolean upperCaseTags) {
        this.upperCaseTags = upperCaseTags;
    }

    protected boolean isUpperCaseTags() {
        return this.upperCaseTags;
    }

    protected void setUpperCaseAttrs(boolean upperCaseAttrs) {
        this.upperCaseAttrs = upperCaseAttrs;
    }

    protected boolean isUpperCaseAttrs() {
        return this.upperCaseAttrs;
    }

    protected void setMakeClean(boolean makeClean) {
        this.makeClean = makeClean;
    }

    protected boolean isMakeClean() {
        return this.makeClean;
    }

    protected void setMakeBare(boolean makeBare) {
        this.makeBare = makeBare;
    }

    protected boolean isMakeBare() {
        return this.makeBare;
    }

    protected void setLogicalEmphasis(boolean logicalEmphasis) {
        this.logicalEmphasis = logicalEmphasis;
    }

    protected boolean isLogicalEmphasis() {
        return this.logicalEmphasis;
    }

    protected void setDropFontTags(boolean dropFontTags) {
        this.dropFontTags = dropFontTags;
    }

    protected boolean isDropFontTags() {
        return this.dropFontTags;
    }

    protected void setDropProprietaryAttributes(boolean dropProprietaryAttributes) {
        this.dropProprietaryAttributes = dropProprietaryAttributes;
    }

    protected boolean isDropProprietaryAttributes() {
        return this.dropProprietaryAttributes;
    }

    protected void setDropEmptyParas(boolean dropEmptyParas) {
        this.dropEmptyParas = dropEmptyParas;
    }

    protected boolean isDropEmptyParas() {
        return this.dropEmptyParas;
    }

    protected void setFixComments(boolean fixComments) {
        this.fixComments = fixComments;
    }

    protected boolean isFixComments() {
        return this.fixComments;
    }

    protected void setTrimEmpty(boolean trimEmpty) {
        this.trimEmpty = trimEmpty;
    }

    protected boolean isTrimEmpty() {
        return this.trimEmpty;
    }

    protected void setBreakBeforeBR(boolean breakBeforeBR) {
        this.breakBeforeBR = breakBeforeBR;
    }

    protected boolean isBreakBeforeBR() {
        return this.breakBeforeBR;
    }

    protected void setBurstSlides(boolean burstSlides) {
        this.burstSlides = burstSlides;
    }

    protected boolean isBurstSlides() {
        return this.burstSlides;
    }

    protected void setNumEntities(boolean numEntities) {
        this.numEntities = numEntities;
    }

    protected boolean isNumEntities() {
        return this.numEntities;
    }

    protected void setQuoteMarks(boolean quoteMarks) {
        this.quoteMarks = quoteMarks;
    }

    protected boolean isQuoteMarks() {
        return this.quoteMarks;
    }

    protected void setQuoteNbsp(boolean quoteNbsp) {
        this.quoteNbsp = quoteNbsp;
    }

    protected boolean isQuoteNbsp() {
        return this.quoteNbsp;
    }

    protected void setQuoteAmpersand(boolean quoteAmpersand) {
        this.quoteAmpersand = quoteAmpersand;
    }

    protected boolean isQuoteAmpersand() {
        return this.quoteAmpersand;
    }

    protected void setWrapAttVals(boolean wrapAttVals) {
        this.wrapAttVals = wrapAttVals;
    }

    protected boolean isWrapAttVals() {
        return this.wrapAttVals;
    }

    protected void setWrapScriptlets(boolean wrapScriptlets) {
        this.wrapScriptlets = wrapScriptlets;
    }

    protected boolean isWrapScriptlets() {
        return this.wrapScriptlets;
    }

    protected void setWrapSection(boolean wrapSection) {
        this.wrapSection = wrapSection;
    }

    protected boolean isWrapSection() {
        return this.wrapSection;
    }

    protected void setWrapAsp(boolean wrapAsp) {
        this.wrapAsp = wrapAsp;
    }

    protected boolean isWrapAsp() {
        return this.wrapAsp;
    }

    protected void setWrapJste(boolean wrapJste) {
        this.wrapJste = wrapJste;
    }

    protected boolean isWrapJste() {
        return this.wrapJste;
    }

    protected void setWrapPhp(boolean wrapPhp) {
        this.wrapPhp = wrapPhp;
    }

    protected boolean isWrapPhp() {
        return this.wrapPhp;
    }

    protected void setFixBackslash(boolean fixBackslash) {
        this.fixBackslash = fixBackslash;
    }

    protected boolean isFixBackslash() {
        return this.fixBackslash;
    }

    protected void setIndentAttributes(boolean indentAttributes) {
        this.indentAttributes = indentAttributes;
    }

    protected boolean isIndentAttributes() {
        return this.indentAttributes;
    }

    protected void setXmlPIs(boolean xmlPIs) {
        this.xmlPIs = xmlPIs;
    }

    protected boolean isXmlPIs() {
        return this.xmlPIs;
    }

    protected void setXmlSpace(boolean xmlSpace) {
        this.xmlSpace = xmlSpace;
    }

    protected boolean isXmlSpace() {
        return this.xmlSpace;
    }

    protected void setEncloseBodyText(boolean encloseBodyText) {
        this.encloseBodyText = encloseBodyText;
    }

    protected boolean isEncloseBodyText() {
        return this.encloseBodyText;
    }

    protected void setEncloseBlockText(boolean encloseBlockText) {
        this.encloseBlockText = encloseBlockText;
    }

    protected boolean isEncloseBlockText() {
        return this.encloseBlockText;
    }

    protected void setKeepFileTimes(boolean keepFileTimes) {
        this.keepFileTimes = keepFileTimes;
    }

    protected boolean isKeepFileTimes() {
        return this.keepFileTimes;
    }

    protected void setWord2000(boolean word2000) {
        this.word2000 = word2000;
    }

    protected boolean isWord2000() {
        return this.word2000;
    }

    protected void setTidyMark(boolean tidyMark) {
        this.tidyMark = tidyMark;
    }

    protected boolean isTidyMark() {
        return this.tidyMark;
    }

    protected void setEmacs(boolean emacs) {
        this.emacs = emacs;
    }

    protected boolean isEmacs() {
        return this.emacs;
    }

    protected void setLiteralAttribs(boolean literalAttribs) {
        this.literalAttribs = literalAttribs;
    }

    protected boolean isLiteralAttribs() {
        return this.literalAttribs;
    }

    protected void setBodyOnly(boolean bodyOnly) {
        this.bodyOnly = bodyOnly;
    }

    protected boolean isBodyOnly() {
        return this.bodyOnly;
    }

    protected void setFixUri(boolean fixUri) {
        this.fixUri = fixUri;
    }

    protected boolean isFixUri() {
        return this.fixUri;
    }

    protected void setLowerLiterals(boolean lowerLiterals) {
        this.lowerLiterals = lowerLiterals;
    }

    protected boolean isLowerLiterals() {
        return this.lowerLiterals;
    }

    protected void setReplaceColor(boolean replaceColor) {
        this.replaceColor = replaceColor;
    }

    protected boolean isReplaceColor() {
        return this.replaceColor;
    }

    protected void setHideComments(boolean hideComments) {
        this.hideComments = hideComments;
    }

    protected boolean isHideComments() {
        return this.hideComments;
    }

    protected void setIndentCdata(boolean indentCdata) {
        this.indentCdata = indentCdata;
    }

    protected boolean isIndentCdata() {
        return this.indentCdata;
    }

    protected void setForceOutput(boolean forceOutput) {
        this.forceOutput = forceOutput;
    }

    protected boolean isForceOutput() {
        return this.forceOutput;
    }

    protected void setShowErrors(int showErrors) {
        this.showErrors = showErrors;
    }

    protected int getShowErrors() {
        return this.showErrors;
    }

    protected void setAsciiChars(boolean asciiChars) {
        this.asciiChars = asciiChars;
    }

    protected boolean isAsciiChars() {
        return this.asciiChars;
    }

    protected void setJoinClasses(boolean joinClasses) {
        this.joinClasses = joinClasses;
    }

    protected boolean isJoinClasses() {
        return this.joinClasses;
    }

    protected void setJoinStyles(boolean joinStyles) {
        this.joinStyles = joinStyles;
    }

    protected boolean isJoinStyles() {
        return this.joinStyles;
    }

    protected void setEscapeCdata(boolean escapeCdata) {
        this.escapeCdata = escapeCdata;
    }

    protected boolean isEscapeCdata() {
        return this.escapeCdata;
    }

    protected void setNcr(boolean ncr) {
        this.ncr = ncr;
    }

    protected boolean isNcr() {
        return this.ncr;
    }

    protected void setCssPrefix(String cssPrefix) {
        this.cssPrefix = cssPrefix;
    }

    protected String getCssPrefix() {
        return this.cssPrefix;
    }

    protected void setReplacementCharEncoding(String replacementCharEncoding) {
        this.replacementCharEncoding = replacementCharEncoding;
    }

    protected String getReplacementCharEncoding() {
        return this.replacementCharEncoding;
    }

    protected void setDefinedTags(int definedTags) {
        this.definedTags = definedTags;
    }

    protected int getDefinedTags() {
        return this.definedTags;
    }

    protected void setNewline(char[] newline) {
        this.newline = newline;
    }

    protected char[] getNewline() {
        return this.newline;
    }

    protected void setRawOut(boolean rawOut) {
        this.rawOut = rawOut;
    }

    protected boolean isRawOut() {
        return this.rawOut;
    }

    protected void setAccessibilityCheckLevel(int accessibilityCheckLevel) {
        this.accessibilityCheckLevel = accessibilityCheckLevel;
    }

    protected int getAccessibilityCheckLevel() {
        return this.accessibilityCheckLevel;
    }

    static {
        Configuration.addConfigOption(new Flag("indent-spaces", "spaces", ParsePropertyImpl.INT));
        Configuration.addConfigOption(new Flag("wrap", "wraplen", ParsePropertyImpl.INT));
        Configuration.addConfigOption(new Flag("tab-size", "tabsize", ParsePropertyImpl.INT));
        Configuration.addConfigOption(new Flag("char-encoding", null, ParsePropertyImpl.CHAR_ENCODING));
        Configuration.addConfigOption(new Flag("input-encoding", null, ParsePropertyImpl.CHAR_ENCODING));
        Configuration.addConfigOption(new Flag("output-encoding", null, ParsePropertyImpl.CHAR_ENCODING));
        Configuration.addConfigOption(new Flag("newline", null, ParsePropertyImpl.NEWLINE));
        Configuration.addConfigOption(new Flag("doctype", "docTypeStr", ParsePropertyImpl.DOCTYPE));
        Configuration.addConfigOption(new Flag("repeated-attributes", "duplicateAttrs", ParsePropertyImpl.REPEATED_ATTRIBUTES));
        Configuration.addConfigOption(new Flag("alt-text", "altText", ParsePropertyImpl.STRING));
        Configuration.addConfigOption(new Flag("slide-style", "slidestyle", ParsePropertyImpl.NAME));
        Configuration.addConfigOption(new Flag("error-file", "errfile", ParsePropertyImpl.NAME));
        Configuration.addConfigOption(new Flag("write-back", "writeback", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("markup", "onlyErrors", ParsePropertyImpl.INVBOOL));
        Configuration.addConfigOption(new Flag("show-warnings", "showWarnings", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("quiet", "quiet", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("indent", "indentContent", ParsePropertyImpl.INDENT));
        Configuration.addConfigOption(new Flag("hide-endtags", "hideEndTags", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("input-xml", "xmlTags", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("output-xml", "xmlOut", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("output-xhtml", "xHTML", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("output-html", "htmlOut", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("add-xml-decl", "xmlPi", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("uppercase-tags", "upperCaseTags", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("uppercase-attributes", "upperCaseAttrs", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("bare", "makeBare", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("clean", "makeClean", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("logical-emphasis", "logicalEmphasis", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("drop-proprietary-attributes", "dropProprietaryAttributes", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("drop-font-tags", "dropFontTags", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("drop-empty-paras", "dropEmptyParas", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("fix-bad-comments", "fixComments", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("break-before-br", "breakBeforeBR", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("split", "burstSlides", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("numeric-entities", "numEntities", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("quote-marks", "quoteMarks", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("quote-nbsp", "quoteNbsp", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("quote-ampersand", "quoteAmpersand", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-attributes", "wrapAttVals", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-script-literals", "wrapScriptlets", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-sections", "wrapSection", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-asp", "wrapAsp", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-jste", "wrapJste", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("wrap-php", "wrapPhp", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("fix-backslash", "fixBackslash", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("indent-attributes", "indentAttributes", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("assume-xml-procins", "xmlPIs", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("add-xml-space", "xmlSpace", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("enclose-text", "encloseBodyText", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("enclose-block-text", "encloseBlockText", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("keep-time", "keepFileTimes", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("word-2000", "word2000", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("tidy-mark", "tidyMark", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("gnu-emacs", "emacs", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("literal-attributes", "literalAttribs", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("show-body-only", "bodyOnly", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("fix-uri", "fixUri", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("lower-literals", "lowerLiterals", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("hide-comments", "hideComments", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("indent-cdata", "indentCdata", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("force-output", "forceOutput", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("show-errors", "showErrors", ParsePropertyImpl.INT));
        Configuration.addConfigOption(new Flag("ascii-chars", "asciiChars", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("join-classes", "joinClasses", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("join-styles", "joinStyles", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("escape-cdata", "escapeCdata", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("language", "language", ParsePropertyImpl.NAME));
        Configuration.addConfigOption(new Flag("ncr", "ncr", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("replace-color", "replaceColor", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("css-prefix", "cssPrefix", ParsePropertyImpl.CSS1SELECTOR));
        Configuration.addConfigOption(new Flag("new-inline-tags", null, ParsePropertyImpl.TAGNAMES));
        Configuration.addConfigOption(new Flag("new-blocklevel-tags", null, ParsePropertyImpl.TAGNAMES));
        Configuration.addConfigOption(new Flag("new-empty-tags", null, ParsePropertyImpl.TAGNAMES));
        Configuration.addConfigOption(new Flag("new-pre-tags", null, ParsePropertyImpl.TAGNAMES));
        Configuration.addConfigOption(new Flag("add-xml-pi", "xmlPi", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("only-errors", "onlyErrors", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("output-raw", "rawOut", ParsePropertyImpl.BOOL));
        Configuration.addConfigOption(new Flag("trim-empty-elements", "trimEmpty", ParsePropertyImpl.BOOL));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Flag
    implements Comparable<Flag> {
        private String name;
        private String fieldName;
        private Field location;
        private ParseProperty parser;

        Flag(String name, String fieldName, ParseProperty parser) {
            this.fieldName = fieldName;
            this.name = name;
            this.parser = parser;
        }

        public Field getLocation() {
            if (this.fieldName != null && this.location == null) {
                try {
                    this.location = Configuration.class.getDeclaredField(this.fieldName);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("NoSuchField exception during config initialization for field " + this.fieldName);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Security exception during config initialization for field " + this.fieldName + ": " + e.getMessage());
                }
            }
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public ParseProperty getParser() {
            return this.parser;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((Flag)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Flag o) {
            return this.name.compareTo(o.name);
        }
    }
}

