/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.gecko.BrowserPreferences;
import com.teamdev.jxbrowser.gecko.WebBrowser;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import java.awt.Font;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.mozilla.interfaces.nsIContentViewer;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIMarkupDocumentViewer;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsIPrefService;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaConfigurable
implements Configurable {
    private static boolean a = true;
    private final MozillaBrowser b;
    private final BrowserPreferences c;
    private final Map<Feature, g> d;

    public static boolean canAutoEnableOfflineMode() {
        return a;
    }

    public static void setAutoEnableOfflineMode(boolean bl) {
        a = bl;
    }

    MozillaConfigurable(MozillaBrowser mozillaBrowser) {
        this.b = mozillaBrowser;
        this.c = new BrowserPreferences();
        this.c.setAllowAuthentication(true);
        this.c.setAllowImages(true);
        this.c.setAllowJavascript(true);
        this.c.setAllowMetaRedirects(true);
        this.c.setAllowPlugins(true);
        this.c.setAllowSubframes(true);
        this.c.setZoom(1.0f);
        this.d = new EnumMap<Feature, g>(Feature.class);
        this.d.put(Feature.DOWNLOAD_IMAGES, new h());
        this.d.put(Feature.JAVASCRIPT, new i());
        this.d.put(Feature.PLUGINS, new f());
        new j().a(false);
        this.b();
    }

    public void disableFeature(Feature feature) {
        this.a(feature, false);
    }

    public void enableFeature(Feature feature) {
        this.a(feature, true);
        if (feature == Feature.PLUGINS) {
            new j().a(false);
        }
    }

    public Map<Feature, Boolean> getFeatures() {
        EnumMap<Feature, Boolean> enumMap = new EnumMap<Feature, Boolean>(Feature.class);
        enumMap.put(Feature.DOWNLOAD_IMAGES, this.c.isAllowImages());
        enumMap.put(Feature.JAVASCRIPT, this.c.isAllowJavascript());
        enumMap.put(Feature.PLUGINS, this.c.isAllowPlugins());
        return enumMap;
    }

    public void setFeatures(Map<Feature, Boolean> map) {
        for (Feature feature : map.keySet()) {
            this.a(feature, map.get(feature));
        }
    }

    public Font getDefaultFont() {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIPrefService nsIPrefService2 = (nsIPrefService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
                nsIPrefBranch nsIPrefBranch3 = nsIPrefService2.getDefaultBranch("font.default.");
                String string = nsIPrefBranch3.getCharPref("x-western");
                nsIPrefBranch nsIPrefBranch4 = nsIPrefService2.getDefaultBranch("font.name." + string + ".");
                String string2 = nsIPrefBranch4.getCharPref("x-western");
                nsIPrefBranch nsIPrefBranch5 = nsIPrefService2.getDefaultBranch("font.size.variable.");
                int n2 = nsIPrefBranch5.getIntPref("x-western");
                atomicReference.set(new Font(string2, 0, n2));
            }
        });
        return (Font)atomicReference.get();
    }

    public void setDefaultFont(final Font font) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIPrefService nsIPrefService2 = (nsIPrefService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
                nsIPrefBranch nsIPrefBranch3 = nsIPrefService2.getDefaultBranch("font.default.");
                String string = nsIPrefBranch3.getCharPref("x-western");
                nsIPrefBranch nsIPrefBranch4 = nsIPrefService2.getDefaultBranch("font.name." + string + ".");
                nsIPrefBranch4.setCharPref("x-western", font.getFamily());
                nsIPrefBranch nsIPrefBranch5 = nsIPrefService2.getDefaultBranch("font.size.variable.");
                nsIPrefBranch5.setIntPref("x-western", font.getSize());
            }
        });
    }

    public int getZoomValue() {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebBrowser nsIWebBrowser2 = MozillaConfigurable.this.b.getPeer().getNsIWebBrowser();
                nsIDOMWindow nsIDOMWindow3 = nsIWebBrowser2.getContentDOMWindow();
                XPCOMManager xPCOMManager = XPCOMManager.getInstance();
                nsIInterfaceRequestor nsIInterfaceRequestor2 = xPCOMManager.queryInterface(nsIDOMWindow3, nsIInterfaceRequestor.class);
                nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)nsIInterfaceRequestor2.getInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
                nsIDocShell nsIDocShell2 = xPCOMManager.queryInterface(nsIWebNavigation2, nsIDocShell.class);
                nsIContentViewer nsIContentViewer2 = nsIDocShell2.getContentViewer();
                nsIMarkupDocumentViewer nsIMarkupDocumentViewer2 = xPCOMManager.queryInterface(nsIContentViewer2, nsIMarkupDocumentViewer.class);
                atomicReference.set(Float.valueOf(nsIMarkupDocumentViewer2.getFullZoom()));
            }
        });
        return (int)(((Float)atomicReference.get()).floatValue() * 100.0f);
    }

    public void setZoomValue(int n2) {
        if (n2 < 10 || n2 > 1000) {
            throw new IllegalArgumentException("Zoom value must be between 10 and 1000.");
        }
        final float f2 = (float)n2 / 100.0f;
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebBrowser nsIWebBrowser2 = MozillaConfigurable.this.b.getPeer().getNsIWebBrowser();
                nsIDOMWindow nsIDOMWindow3 = nsIWebBrowser2.getContentDOMWindow();
                XPCOMManager xPCOMManager = XPCOMManager.getInstance();
                nsIInterfaceRequestor nsIInterfaceRequestor2 = xPCOMManager.queryInterface(nsIDOMWindow3, nsIInterfaceRequestor.class);
                nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)nsIInterfaceRequestor2.getInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
                nsIDocShell nsIDocShell2 = xPCOMManager.queryInterface(nsIWebNavigation2, nsIDocShell.class);
                nsIContentViewer nsIContentViewer2 = nsIDocShell2.getContentViewer();
                nsIMarkupDocumentViewer nsIMarkupDocumentViewer2 = xPCOMManager.queryInterface(nsIContentViewer2, nsIMarkupDocumentViewer.class);
                nsIMarkupDocumentViewer2.setFullZoom(f2);
            }
        });
    }

    private void a(Feature feature, boolean bl) {
        if (this.d.containsKey(feature)) {
            this.d.get(feature).a(bl);
            this.a();
        }
    }

    private void a() {
        WebBrowser webBrowser = this.b.getPeer();
        webBrowser.setPreferences(this.c);
        webBrowser.refresh();
    }

    private void b() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIPrefService nsIPrefService2 = (nsIPrefService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
                nsIPrefBranch nsIPrefBranch3 = nsIPrefService2.getBranch("zoom.");
                nsIPrefBranch3.setIntPref("maxPercent", 1000);
                nsIPrefBranch3.setIntPref("minPercent", 10);
            }
        });
    }

    private class j
    implements g {
        private j() {
        }

        public void a(boolean bl) {
            nsIPrefService nsIPrefService2 = (nsIPrefService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
            nsIPrefBranch nsIPrefBranch3 = nsIPrefService2.getBranch("plugin.scan.");
            if (bl) {
                nsIPrefBranch3.setCharPref("SunJRE", System.getProperty("java.specification.version"));
            } else {
                nsIPrefBranch3.setCharPref("SunJRE", "999");
            }
        }
    }

    private class f
    implements g {
        private f() {
        }

        public void a(boolean bl) {
            MozillaConfigurable.this.c.setAllowPlugins(bl);
        }
    }

    private class i
    implements g {
        private i() {
        }

        public void a(boolean bl) {
            MozillaConfigurable.this.c.setAllowJavascript(bl);
        }
    }

    private class h
    implements g {
        private h() {
        }

        public void a(boolean bl) {
            MozillaConfigurable.this.c.setAllowImages(bl);
        }
    }

    private static interface g {
        public void a(boolean var1);
    }
}

