/*
 *  soapUI, copyright (C) 2004-2012 smartbear.com 
 *
 *  soapUI is free software; you can redistribute it and/or modify it under the 
 *  terms of version 2.1 of the GNU Lesser General Public License as published by 
 *  the Free Software Foundation.
 *
 *  soapUI is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 *  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *  See the GNU Lesser General Public License for more details at gnu.org.
 */

package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

/**
 * Renames a WsdlProject
 * 
 * @author Ole.Matzura
 */

public class RenameProjectAction extends AbstractSoapUIAction<WsdlProject>
{
	public static final String SOAPUI_ACTION_ID = "RenameProjectAction";

	public RenameProjectAction()
	{
		super( "Rename", "Renames this project" );
	}

	public void perform( WsdlProject project, Object param )
	{
		String name = UISupport.prompt( "Specify name of project", "Rename Project", project.getName() );
		if( name == null || name.equals( project.getName() ) )
			return;
		while( project.getWorkspace().getProjectByName( name.trim() ) != null )
		{
			name = UISupport.prompt( "Specify unique name of Project", "Rename Project", project.getName() );
			if( name == null || name.equals( project.getName() ) )
				return;
		}

		project.setName( name );
	}
}
