/*
 *  soapUI, copyright (C) 2004-2012 smartbear.com 
 *
 *  soapUI is free software; you can redistribute it and/or modify it under the 
 *  terms of version 2.1 of the GNU Lesser General Public License as published by 
 *  the Free Software Foundation.
 *
 *  soapUI is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 *  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *  See the GNU Lesser General Public License for more details at gnu.org.
 */

package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

/**
 * Moves the specified WsdlTestCase down one step in the WsdlTestSuites list of
 * WsdlTestCases
 * 
 * @author ole.matzura
 */

public class MoveTestSuiteDownAction extends AbstractSoapUIAction<WsdlTestSuite>
{
	public MoveTestSuiteDownAction()
	{
		super( "Move TestSuite Down", "Moves this TestSuite down" );
	}

	public void perform( WsdlTestSuite testSuite, Object param )
	{
		WsdlProject project = testSuite.getProject();
		int ix = project.getIndexOfTestSuite( testSuite );
		if( ix == -1 || ix >= project.getTestSuiteCount() - 1 )
			return;

		project.moveTestSuite( ix, 1 );
		UISupport.select( testSuite );
	}
}
