/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import cadyts.utilities.math.MultinomialLogit;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.Router;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ScatterPlotAnalyzer
implements TabularFileHandler {
    private final Network network;
    private boolean printTotals = false;
    private Map<List<Node>, Integer> route2count = new HashMap<List<Node>, Integer>();
    private final int burnIn;
    private final int sampleInterval;
    private final int maxSampleSize;
    private final double scale;
    private final LinkCost linkCost;
    private int totalCnt;
    private int sampleSize;

    public ScatterPlotAnalyzer(Network network, int burnIn, int sampleInterval, int maxSampleSize, double scale, LinkCost linkCost) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        if (burnIn < 0) {
            throw new IllegalArgumentException("burn in < 0");
        }
        if (sampleInterval < 1) {
            throw new IllegalArgumentException("sample interval < 1");
        }
        if (maxSampleSize < 1) {
            throw new IllegalArgumentException("max. sample size < 1");
        }
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost is null");
        }
        this.network = network;
        this.burnIn = burnIn;
        this.sampleInterval = sampleInterval;
        this.maxSampleSize = maxSampleSize;
        this.scale = scale;
        this.linkCost = linkCost;
    }

    public void setPrintTotals(boolean printTotals) {
        this.printTotals = printTotals;
    }

    public void run(String fromFile, String toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("from file is null");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("to file is null");
        }
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fromFile, this);
        long totalCnt = 0L;
        for (int cnt : this.route2count.values()) {
            totalCnt += (long)cnt;
        }
        ArrayList<List<Node>> orderedRoutes = new ArrayList<List<Node>>(this.route2count.keySet());
        MultinomialLogit mnl = new MultinomialLogit(this.route2count.size(), 1);
        mnl.setUtilityScale(1.0);
        mnl.setCoefficient(0, -this.scale);
        int i = 0;
        while (i < orderedRoutes.size()) {
            List<Link> route = Router.toLinkRoute((List)orderedRoutes.get(i));
            double cost = 0.0;
            for (Link link : route) {
                cost += this.linkCost.getCost(link);
            }
            mnl.setAttribute(i, 0, cost);
            ++i;
        }
        mnl.enforcedUpdate();
        PrintWriter writer = new PrintWriter(toFile);
        int i2 = 0;
        while (i2 < orderedRoutes.size()) {
            if (this.printTotals) {
                writer.print(mnl.getProbs().get(i2) * (double)totalCnt);
                writer.print(" ");
                writer.println((double)this.route2count.get(orderedRoutes.get(i2)).intValue());
            } else {
                writer.print(mnl.getProbs().get(i2));
                writer.print(" ");
                writer.println((double)this.route2count.get(orderedRoutes.get(i2)).intValue() / (double)totalCnt);
            }
            ++i2;
        }
        writer.flush();
        writer.close();
    }

    @Override
    public void startDocument() {
        this.totalCnt = 0;
        this.sampleSize = 0;
    }

    @Override
    public String preprocess(String line) {
        int semicolonIndex = line.indexOf(";");
        if (semicolonIndex < 0) {
            return line;
        }
        return line.substring(0, semicolonIndex);
    }

    @Override
    public void startRow(String[] row) {
        if (row.length == 0) {
            return;
        }
        if (row.length == 1) {
            throw new RuntimeException("paths of only one node are not possible");
        }
        if (this.totalCnt < this.burnIn || (this.totalCnt - this.burnIn) % this.sampleInterval != 0 || this.sampleSize >= this.maxSampleSize) {
            ++this.totalCnt;
            return;
        }
        ++this.totalCnt;
        ++this.sampleSize;
        LinkedList<Node> route = new LinkedList<Node>();
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            route.add(this.network.getNode(element));
            ++n2;
        }
        Integer oldCnt = this.route2count.get(route);
        this.route2count.put(route, (oldCnt == null ? 0 : oldCnt) + 1);
    }

    @Override
    public void endDocument() {
    }
}

