/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.misc;

import cadyts.utilities.misc.CacheUpdater;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Cache<K, V> {
    private final CacheUpdater<K, V> updater;
    private final int capacity;
    private Map<K, V> key2value = new HashMap();
    private LinkedList<K> lastKeys = new LinkedList();

    public Cache(CacheUpdater<K, V> updater, int capacity) {
        if (updater == null) {
            throw new IllegalArgumentException("updater is null");
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity is below one");
        }
        this.updater = updater;
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        return this.key2value.size();
    }

    public void clear() {
        this.key2value.clear();
        this.lastKeys.clear();
    }

    public boolean containsKey(K key) {
        return this.key2value.containsKey(key);
    }

    private void shrinkToCapacity() {
        while (this.lastKeys.size() > this.capacity) {
            this.key2value.remove(this.lastKeys.removeLast());
        }
    }

    public V get(K key) {
        V value = this.key2value.get(key);
        if (value == null) {
            value = this.updater.compute(key);
            this.key2value.put(key, value);
            this.lastKeys.remove(key);
            this.lastKeys.addFirst(key);
            this.shrinkToCapacity();
        }
        return value;
    }

    public void copy(Cache<K, V> source) {
        this.clear();
        this.key2value.putAll(source.key2value);
        this.lastKeys.addAll(source.lastKeys);
        this.shrinkToCapacity();
    }
}

