/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.utilities.misc.Time;
import cadyts.utilities.visualization.network.MoviePlayer;
import cadyts.utilities.visualization.network.NetVis;
import cadyts.utilities.visualization.network.Printer;
import cadyts.utilities.visualization.network.RenderableDynamicData;
import cadyts.utilities.visualization.network.VisConfig;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlToolbar
extends JToolBar
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String TO_START = "to_start";
    private static final String STEP_B = "step_b";
    private static final String PLAY = "play";
    private static final String STEP_F = "step_f";
    private static final String TO_END = "to_end";
    private static final String ZOOM_IN = "zoom_in";
    private static final String ZOOM_OUT = "zoom_out";
    private static final String SET_TIME = "set_time";
    private static final String TOGGLE_NODE_LABELS = "node labels";
    private static final String TOGGLE_LINK_LABELS = "link labels";
    private static final String TOGGLE_ANTIALIAS = "anti-alias";
    private static final String PRINT = "print";
    private NetVis viz;
    private Timer movieTimer = null;
    private RenderableDynamicData<Link> data;
    private JButton playButton;
    private JFormattedTextField timeField;
    private float scale = 1.0f;
    private VisConfig visConfig;

    public ControlToolbar(NetVis viz, RenderableDynamicData<Link> data, VisConfig visConfig) {
        this.viz = viz;
        this.data = data;
        this.visConfig = visConfig;
        this.addButtons();
    }

    private void addButtons() {
        if (this.data != null) {
            this.add(this.createButton("|<", TO_START));
            this.add(this.createButton("<", STEP_B));
            this.playButton = this.createButton("PLAY", PLAY);
            this.add(this.playButton);
            this.add(this.createButton(">", STEP_F));
            this.add(this.createButton(">|", TO_END));
        }
        if (this.data != null) {
            this.timeField = new JFormattedTextField(new MessageFormat("{0,number,00}-{1,number,00}-{2,number,00}"));
            this.timeField.setMaximumSize(new Dimension(75, 30));
            this.timeField.setActionCommand(SET_TIME);
            this.timeField.setHorizontalAlignment(0);
            this.add(this.timeField);
            this.timeField.addActionListener(this);
        }
        this.add(this.createButton("--", ZOOM_OUT));
        this.add(this.createButton("+", ZOOM_IN));
        this.add(this.createButton("PRN", PRINT));
        this.createCheckBoxes();
        Integer min = 0;
        Integer max = 2000;
        Integer step = 1;
        SpinnerNumberModel model = new SpinnerNumberModel(new Integer(this.visConfig.getLinkWidthFactor()), min, max, step);
        JSpinner spin = ControlToolbar.addLabeledSpinner(this, "Lanewidth", model);
        spin.setMaximumSize(new Dimension(75, 30));
        spin.addChangeListener(this);
    }

    private JButton createButton(String display, String actionCommand) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        button.setText(display);
        return button;
    }

    public void updateTimeLabel() {
        if (this.data != null) {
            int time_s = this.data.getStartTime_s() + this.data.currentBin() * this.data.getBinSize_s();
            this.timeField.setText(Time.strFromSec(time_s));
        }
    }

    void repaintForMovie() {
        this.updateTimeLabel();
    }

    private void stopMovie() {
        if (this.movieTimer != null) {
            this.movieTimer.cancel();
            this.movieTimer = null;
            this.playButton.setText("PLAY");
        }
    }

    private void pressed_TO_START() throws IOException {
        this.stopMovie();
        this.data.toStart();
    }

    private void pressed_STEP_B() throws IOException {
        this.stopMovie();
        this.data.bwd();
    }

    private void pressed_PLAY() {
        if (this.movieTimer == null) {
            this.movieTimer = new Timer();
            MoviePlayer moviePlayer = new MoviePlayer(this.data, this.viz);
            this.movieTimer.schedule((TimerTask)moviePlayer, 0L, (long)this.visConfig.getDelay_ms());
            this.playButton.setText("STOP");
        } else {
            this.stopMovie();
        }
    }

    private void pressed_STEP_F() throws IOException {
        this.stopMovie();
        this.data.fwd();
    }

    private void pressed_TO_END() throws IOException {
        this.stopMovie();
        this.data.toEnd();
    }

    private void pressed_ZOOM_OUT() {
        this.scale = (float)((double)this.scale / 1.42);
        this.viz.scaleNetwork(this.scale);
    }

    private void pressed_ZOOM_IN() {
        this.scale = (float)((double)this.scale * 1.42);
        this.viz.scaleNetwork(this.scale);
    }

    private void pressed_PRINT() {
        new Printer(this.viz.networkComponent(), this.viz.networkScrollPane().getViewport()).run();
    }

    private void changed_SET_TIME(ActionEvent event) throws IOException {
        String newTime = ((JFormattedTextField)event.getSource()).getText();
        int newTime_s = Time.secFromStr(newTime);
        this.stopMovie();
        this.data.toTime(newTime_s);
    }

    @Override
    public void paint(Graphics g) {
        if (this.data != null) {
            this.updateTimeLabel();
        }
        super.paint(g);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            if (TO_START.equals(command)) {
                this.pressed_TO_START();
            } else if (STEP_B.equals(command)) {
                this.pressed_STEP_B();
            } else if (PLAY.equals(command)) {
                this.pressed_PLAY();
            } else if (STEP_F.equals(command)) {
                this.pressed_STEP_F();
            } else if (TO_END.equals(command)) {
                this.pressed_TO_END();
            } else if (ZOOM_OUT.equals(command)) {
                this.pressed_ZOOM_OUT();
            } else if (ZOOM_IN.equals(command)) {
                this.pressed_ZOOM_IN();
            } else if (PRINT.equals(command)) {
                this.pressed_PRINT();
            } else if (command.equals(SET_TIME)) {
                this.changed_SET_TIME(event);
            }
        }
        catch (IOException e) {
            System.err.println("ControlToolbar encountered problem: " + e);
        }
        this.updateTimeLabel();
        this.repaint();
        this.viz.paintNow();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    protected static JSpinner addLabeledSpinner(Container c, String label, SpinnerModel model) {
        JLabel l = new JLabel(label);
        c.add(l);
        JSpinner spinner = new JSpinner(model);
        l.setLabelFor(spinner);
        c.add(spinner);
        return spinner;
    }

    private void createCheckBoxes() {
        JCheckBox nodeLabelBox = new JCheckBox(TOGGLE_NODE_LABELS);
        nodeLabelBox.setMnemonic(78);
        nodeLabelBox.setSelected(this.visConfig.getShowNodeLabels());
        nodeLabelBox.addItemListener(this);
        this.add(nodeLabelBox);
        JCheckBox linkLabelBox = new JCheckBox(TOGGLE_LINK_LABELS);
        linkLabelBox.setMnemonic(76);
        linkLabelBox.setSelected(this.visConfig.getShowLinkLabels());
        linkLabelBox.addItemListener(this);
        this.add(linkLabelBox);
        JCheckBox AABox = new JCheckBox(TOGGLE_ANTIALIAS);
        AABox.setMnemonic(65);
        AABox.setSelected(false);
        AABox.addItemListener(this);
        this.add(AABox);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox source = (JCheckBox)e.getItemSelectable();
        if (source.getText().equals(TOGGLE_NODE_LABELS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setShowNodeLabels(false);
            } else {
                this.visConfig.setShowNodeLabels(true);
            }
        } else if (source.getText().equals(TOGGLE_LINK_LABELS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setShowLinkLabels(false);
            } else {
                this.visConfig.setShowLinkLabels(true);
            }
        } else if (source.getText().equals(TOGGLE_ANTIALIAS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setUseAntiAliasing(false);
            } else {
                this.visConfig.setUseAntiAliasing(true);
            }
        }
        this.repaint();
        this.viz.paintNow();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        int i = ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue();
        this.visConfig.setLinkWidthFactor(i);
        this.repaint();
        this.viz.paintNow();
    }
}

