/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.MATSimNetworkLoader;
import cadyts.supply.network.Network;
import cadyts.utilities.visualization.network.BackgroundRenderer;
import cadyts.utilities.visualization.network.ControlToolbar;
import cadyts.utilities.visualization.network.LabelRenderer;
import cadyts.utilities.visualization.network.LinkSetRenderer;
import cadyts.utilities.visualization.network.MATSimNetworkPreprocessor;
import cadyts.utilities.visualization.network.NetJComponent;
import cadyts.utilities.visualization.network.NetVisScrollPane;
import cadyts.utilities.visualization.network.NodeSetRenderer;
import cadyts.utilities.visualization.network.RenderableDynamicData;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class NetVis {
    public static final String FILE_SUFFIX = "vis";
    private JFrame vizFrame;
    private NetVisScrollPane networkScrollPane;
    private NetJComponent networkComponent;
    private ControlToolbar buttonComponent;

    public NetVis(VisConfig visConfig, Network network, VisNetworkData netData, RenderableDynamicData<Link> data) {
        LinkSetRenderer linkSetRenderer = new LinkSetRenderer(visConfig, network, netData, data);
        BackgroundRenderer backgroundRenderer = new BackgroundRenderer(visConfig, netData);
        NodeSetRenderer nodeSetRenderer = new NodeSetRenderer(visConfig, network, netData);
        LabelRenderer mainRenderer = new LabelRenderer(visConfig, network, netData);
        mainRenderer.append(linkSetRenderer);
        linkSetRenderer.append(nodeSetRenderer);
        nodeSetRenderer.append(backgroundRenderer);
        this.vizFrame = new JFrame("");
        this.vizFrame.setDefaultCloseOperation(3);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.buttonComponent = new ControlToolbar(this, data, visConfig);
        this.vizFrame.getContentPane().add((Component)this.buttonComponent, "North");
        this.networkComponent = new NetJComponent(mainRenderer, visConfig, netData);
        mainRenderer.setTargetComponent(this.networkComponent);
        this.networkScrollPane = new NetVisScrollPane(this.networkComponent);
        this.vizFrame.getContentPane().add((Component)this.networkScrollPane, "Center");
        vizMouseHandler handi = new vizMouseHandler();
        this.networkScrollPane.addMouseMotionListener(handi);
        this.networkScrollPane.addMouseListener(handi);
        this.networkScrollPane.getViewport().addChangeListener(handi);
    }

    static AffineTransform newLinear2PlaneTransform(double offset_m, double displayedLength_m, double startEasting, double startNorthing, double endEasting, double endNorthing, double length_m) {
        double tx = startEasting;
        double ty = startNorthing;
        AffineTransform result = AffineTransform.getTranslateInstance(tx, ty);
        double dx = endEasting - startEasting;
        double dy = endNorthing - startNorthing;
        double theta = Math.atan2(dy, dx);
        result.rotate(theta);
        double sx = displayedLength_m / length_m;
        double sy = 1.0;
        result.scale(sx, sy);
        tx = offset_m * length_m / displayedLength_m;
        ty = 0.0;
        result.translate(tx, ty);
        return result;
    }

    static AffineTransform newLinear2PlaneTransform(Link link, VisNodeData fromNodeData, VisNodeData toNodeData, double lengthAttribute_m) {
        double offset_m;
        double startEasting = fromNodeData.getEasting();
        double startNorthing = fromNodeData.getNorthing();
        double endEasting = toNodeData.getEasting();
        double endNorthing = toNodeData.getNorthing();
        double deltaNorthing = endNorthing - startNorthing;
        double deltaEasting = endEasting - startEasting;
        double result = deltaNorthing * deltaNorthing;
        double nodeDist_m = Math.sqrt(result += deltaEasting * deltaEasting);
        double length_m = nodeDist_m - 2.0 * (offset_m = 0.0);
        if (length_m <= 0.0) {
            length_m = nodeDist_m / 2.0;
            offset_m = (nodeDist_m - length_m) / 2.0;
        }
        return NetVis.newLinear2PlaneTransform(offset_m, length_m, startEasting, startNorthing, endEasting, endNorthing, lengthAttribute_m);
    }

    void repaintForMovie() {
        this.networkComponent.repaint();
        this.buttonComponent.repaintForMovie();
    }

    Component networkComponent() {
        return this.networkComponent;
    }

    NetVisScrollPane networkScrollPane() {
        return this.networkScrollPane;
    }

    public void paintNow() {
        if (this.vizFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetVis.this.vizFrame.paint(NetVis.this.vizFrame.getGraphics());
                }
            });
        }
    }

    public void run() {
        this.vizFrame.pack();
        this.vizFrame.setVisible(true);
    }

    public void scaleNetwork(float scale) {
        this.networkScrollPane.scaleNetwork(scale);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("STARTED");
        MATSimNetworkLoader loader = new MATSimNetworkLoader();
        Network net = loader.load("testdata/matsim/tel-aviv-net.xml");
        VisNetworkData netData = new MATSimNetworkPreprocessor().newVisData(net);
        VisConfig config = new VisConfig();
        RenderableDynamicData<Link> renderData = null;
        config.setColorDef("BLUE -1.0 GREEN 0.0 YELLOW 0.5 RED 1.0");
        NetVis vis = new NetVis(config, net, netData, renderData);
        vis.run();
        System.out.println("DONE");
    }

    class vizMouseHandler
    extends MouseInputAdapter
    implements ChangeListener {
        public Point start = null;
        public Rectangle currentRect = null;
        public int button = 0;

        vizMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            this.button = e.getButton();
            this.start = new Point(x, y);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.button == 1) {
                this.updateSize(e);
            } else if (this.button == 2) {
                int deltax = this.start.x - e.getX();
                int deltay = this.start.y - e.getY();
                this.start.x = e.getX();
                this.start.y = e.getY();
                NetVis.this.networkScrollPane.moveNetwork(deltax, deltay);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.button == 1) {
                this.updateSize(e);
                if (this.currentRect.getHeight() > 10.0 && this.currentRect.getWidth() > 10.0) {
                    float scale = NetVis.this.buttonComponent.getScale();
                    scale = NetVis.this.networkScrollPane.scaleNetwork(this.currentRect, scale);
                    NetVis.this.buttonComponent.setScale(scale);
                }
                this.currentRect = null;
            }
            this.button = 0;
        }

        void updateSize(MouseEvent e) {
            this.currentRect = new Rectangle(this.start);
            this.currentRect.add(e.getX(), e.getY());
            NetVis.this.networkScrollPane.getGraphics().drawRect(this.currentRect.x, this.currentRect.y, this.currentRect.width, this.currentRect.height);
            NetVis.this.networkScrollPane.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NetVis.this.networkScrollPane.updateViewClipRect();
        }
    }
}

