/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.visualization.network.NetJComponent;
import cadyts.utilities.visualization.network.RendererA;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

class NodeSetRenderer
extends RendererA {
    public static boolean RENDER_NODES = false;
    private final Network network;

    NodeSetRenderer(VisConfig visConfig, Network network, VisNetworkData netData) {
        super(visConfig, netData);
        this.network = network;
    }

    @Override
    public void setTargetComponent(NetJComponent comp) {
        super.setTargetComponent(comp);
    }

    @Override
    protected synchronized void myRendering(Graphics2D display, AffineTransform boxTransform) {
        if (!RENDER_NODES) {
            return;
        }
        double laneWidth = 4.0 * (double)this.getVisConfig().getLinkWidthFactor();
        NetJComponent comp = this.getNetJComponent();
        AffineTransform originalTransform = display.getTransform();
        display.setStroke(new BasicStroke(Math.round(0.05 * laneWidth)));
        AffineTransform nodeTransform = new AffineTransform(originalTransform);
        nodeTransform.concatenate(boxTransform);
        display.setTransform(nodeTransform);
        for (Node node : this.network.getNodes()) {
            double y;
            VisNodeData nodeData = this.netData().getVisNodeData(node);
            double x = nodeData.getEasting();
            if (!comp.checkLineInClip(x, y = nodeData.getNorthing(), x, y)) continue;
            display.setColor(Color.WHITE);
            display.fillOval((int)(x - laneWidth), (int)(y - laneWidth), (int)(2.0 * laneWidth), (int)(2.0 * laneWidth));
            display.setColor(Color.BLACK);
            display.drawOval((int)(x - laneWidth), (int)(y - laneWidth), (int)(2.0 * laneWidth), (int)(2.0 * laneWidth));
        }
        display.setTransform(originalTransform);
    }
}

