/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import roadnetwork.Edge;
import roadnetwork.Junction;
import roadnetwork.Lane;
import roadnetwork.RoadNetwork;
import shapes.Point2DExt;

public class RoadNetworkParser {
    public RoadNetwork ParseXMLNetFile(Document roadNetworkXMLDocument) throws Exception {
        RoadNetwork net = new RoadNetwork();
        Element docel = roadNetworkXMLDocument.getDocumentElement();
        NodeList edges = docel.getElementsByTagName("edge");
        List<Edge> parsedEdges = this.ParseEdges(edges);
        NodeList successors = docel.getElementsByTagName("succ");
        this.ParseDeprecatedSuccessors(successors, parsedEdges);
        NodeList successors2 = docel.getElementsByTagName("connection");
        this.ParseNewSuccessors(successors, parsedEdges);
        net.AddElements(parsedEdges);
        NodeList junctions = docel.getElementsByTagName("junction");
        List<Junction> parsedJunctions = this.ParseJunctions(junctions);
        net.AddElements(parsedJunctions);
        return net;
    }

    private List<Edge> ParseEdges(NodeList xmlEdgeNodes) {
        ArrayList<Edge> parsedEdges = new ArrayList<Edge>();
        int totalEdges = xmlEdgeNodes.getLength();
        int i = 0;
        while (i < totalEdges) {
            Node edge = xmlEdgeNodes.item(i);
            NamedNodeMap edgeAttributes = edge.getAttributes();
            Node function = edgeAttributes.getNamedItem("function");
            if (function == null || function.getNodeValue().equals("normal")) {
                Edge e = new Edge();
                e.setId(edgeAttributes.getNamedItem("id").getNodeValue());
                e.setFrom(edgeAttributes.getNamedItem("from").getNodeValue());
                e.setTo(edgeAttributes.getNamedItem("to").getNodeValue());
                Node prio = edgeAttributes.getNamedItem("priority");
                if (prio != null) {
                    e.setPriority(Integer.parseInt(prio.getNodeValue()));
                } else {
                    e.setPriority(-1);
                }
                NodeList lanes = ((Element)edge).getElementsByTagName("lane");
                int totalLanes = lanes.getLength();
                int j = 0;
                while (j < totalLanes) {
                    String[] coords;
                    Node lane = lanes.item(j);
                    Lane l = new Lane();
                    NamedNodeMap laneAttributes = lane.getAttributes();
                    if (j == 0) {
                        e.setLength(Float.parseFloat(laneAttributes.getNamedItem("length").getNodeValue()));
                        e.setSpeedLimit(Float.parseFloat(laneAttributes.getNamedItem("speed").getNodeValue()));
                    }
                    l.setId(laneAttributes.getNamedItem("id").getNodeValue());
                    ArrayList<Point2DExt> points = new ArrayList<Point2DExt>();
                    String[] stringArray = coords = laneAttributes.getNamedItem("shape").getNodeValue().split(" ");
                    int n = coords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String coord = stringArray[n2];
                        String[] from = coord.split(",");
                        double fromx = Double.parseDouble(from[0]);
                        double fromy = Double.parseDouble(from[1]);
                        points.add(new Point2DExt(fromx, fromy));
                        ++n2;
                    }
                    l.SetShape(points);
                    e.AddLane(l);
                    ++j;
                }
                e.CalculateShape();
                parsedEdges.add(e);
            }
            ++i;
        }
        return parsedEdges;
    }

    private void ParseDeprecatedSuccessors(NodeList succNodes, List<Edge> edges) {
        int numberSuccNodes = succNodes.getLength();
        int nodeIndex = 0;
        while (nodeIndex < numberSuccNodes) {
            Node succNode = succNodes.item(nodeIndex);
            NamedNodeMap succAttributes = succNode.getAttributes();
            String edgeId = succAttributes.getNamedItem("edge").getNodeValue();
            Edge edge = null;
            for (Edge e : edges) {
                if (!e.getId().equals(edgeId)) continue;
                edge = e;
            }
            if (edge != null) {
                String laneId = succAttributes.getNamedItem("lane").getNodeValue();
                Lane lane = null;
                for (Lane l : edge.getLanes()) {
                    if (!l.getId().equals(laneId)) continue;
                    lane = l;
                }
                if (lane == null) {
                    System.out.printf("Lane %s not found\n", laneId);
                } else {
                    NodeList childsOfSuccNode = succNode.getChildNodes();
                    int numberOfChilds = childsOfSuccNode.getLength();
                    int chidIndex = 0;
                    while (chidIndex < numberOfChilds) {
                        NamedNodeMap childAttributes;
                        String connectedLaneId;
                        String connectedEdgeId;
                        Node child = childsOfSuccNode.item(chidIndex);
                        if (child.getNodeName().equals("succlane") && (connectedEdgeId = this.findEdgeIdToLaneId(connectedLaneId = (childAttributes = child.getAttributes()).getNamedItem("lane").getNodeValue(), edges)) != null) {
                            lane.AddConnectedEdge(connectedEdgeId);
                        }
                        ++chidIndex;
                    }
                }
            }
            ++nodeIndex;
        }
    }

    private void ParseNewSuccessors(NodeList connNodes, List<Edge> edges) {
        int numberConnNodes = connNodes.getLength();
        int nodeIndex = 0;
        while (nodeIndex < numberConnNodes) {
            Node succNode = connNodes.item(nodeIndex);
            NamedNodeMap succAttributes = succNode.getAttributes();
            String fromId = succAttributes.getNamedItem("from").getNodeValue();
            Edge from = null;
            for (Edge e : edges) {
                if (!e.getId().equals(fromId)) continue;
                from = e;
            }
            if (from != null) {
                String toId = succAttributes.getNamedItem("to").getNodeValue();
                Edge to = null;
                for (Edge e : edges) {
                    if (!e.getId().equals(toId)) continue;
                    to = e;
                }
                if (to != null) {
                    String fromLaneId = succAttributes.getNamedItem("fromLane").getNodeValue();
                    Lane fromLane = from.getLanes().get(Integer.parseInt(fromLaneId));
                    fromLane.AddConnectedEdge(toId);
                }
            }
            ++nodeIndex;
        }
    }

    private String findEdgeIdToLaneId(String laneId, List<Edge> edges) {
        for (Edge e : edges) {
            for (Lane l : e.getLanes()) {
                if (!l.getId().equals(laneId)) continue;
                return e.getId();
            }
        }
        return null;
    }

    private List<Junction> ParseJunctions(NodeList xmlJunctionNodes) {
        ArrayList<Junction> parsedJunctions = new ArrayList<Junction>();
        int totalJunctions = xmlJunctionNodes.getLength();
        int i = 0;
        while (i < totalJunctions) {
            Node junction = xmlJunctionNodes.item(i);
            NamedNodeMap junctionAttributes = junction.getAttributes();
            Node function = junctionAttributes.getNamedItem("type");
            if (!function.getNodeValue().equals("internal")) {
                Junction j = new Junction();
                j.setId(junctionAttributes.getNamedItem("id").getNodeValue());
                j.setType(junctionAttributes.getNamedItem("type").getNodeValue());
                String coordinates = junctionAttributes.getNamedItem("shape").getNodeValue();
                if (coordinates.equals("")) {
                    j.SetShape(null);
                } else {
                    String[] coords = coordinates.split(" ");
                    ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
                    if (coords.length > 0 && coords[0] != "") {
                        String[] stringArray = coords;
                        int n = coords.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String coord = stringArray[n2];
                            String[] from = coord.split(",");
                            float fromx = Float.parseFloat(from[0]);
                            float fromy = Float.parseFloat(from[1]);
                            points.add(new Point2D.Float(fromx, fromy));
                            ++n2;
                        }
                    }
                    j.SetShape(points);
                }
                parsedJunctions.add(j);
            }
            ++i;
        }
        return parsedJunctions;
    }
}

