/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.Project;
import helpers.ApplicationSettings;
import helpers.StreamGobbler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import roadnetwork.RoadNetwork;
import simulation.CustomComparator;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Simulation;
import simulation.TrafficGenerator;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.TrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class SimulationExporter {
    private static void ExportNet(RoadNetwork net, String path, String name, boolean speedInKMH) throws Exception {
        FileOutputStream edgefo = new FileOutputStream(String.valueOf(path) + File.separator + name + ".edg.xml");
        FileOutputStream nodefo = new FileOutputStream(String.valueOf(path) + File.separator + name + ".nod.xml");
        net.RemoveDeletedFromXMLDocuments(nodefo, edgefo);
        edgefo.close();
        nodefo.close();
        String[] args = new String[]{String.valueOf(name) + ".nod.xml", String.valueOf(name) + ".edg.xml", String.valueOf(name) + ".net.xml", ""};
        if (speedInKMH) {
            args[3] = "--speed-in-kmh";
        }
        ProcessBuilder pb = new ProcessBuilder(ApplicationSettings.getNetConvertPath(), "-n", args[0], "-e", args[1], "-o", args[2], args[3]);
        pb.directory(new File(path));
        Process sumo = pb.start();
        StreamGobbler gi = new StreamGobbler(sumo.getInputStream());
        StreamGobbler ge = new StreamGobbler(sumo.getErrorStream());
        gi.start();
        ge.start();
        int exitvalue = sumo.waitFor();
        gi.stop();
        ge.stop();
        List<String> gir = gi.getReadLines();
        List<String> ger = ge.getReadLines();
        for (String s : ger) {
            System.out.println(s);
        }
    }

    private static void ExportPolygons(List<TrafficDefinitionLayer> layersToExport, String path, String name) throws Exception {
        StringBuilder polygonBuilder = new StringBuilder();
        for (TrafficDefinitionLayer layer : layersToExport) {
            for (TrafficDefinitionElement element : layer.getElements()) {
                if (!element.getExportPolygon() || !element.isEnabled()) continue;
                polygonBuilder.append(element.getGeometryXML());
            }
        }
        BufferedWriter geomout = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + name + ".geometry.xml"));
        geomout.write("<polys>\n");
        geomout.write(polygonBuilder.toString());
        geomout.write("</polys>\n");
        geomout.close();
    }

    public static void ExportSimulation(Project project, List<TrafficDefinitionLayer> layersToExport) {
        Simulation sim = project.getSimulation();
        if (JOptionPane.showConfirmDialog(null, "All files in the folder " + sim.getExportPath() + " will be deleted.\nAre you sure you want to continue?", "Confirm file deletion", 0, 2) == 0) {
            File exportFolder = new File(sim.getExportPath());
            File[] fileArray = exportFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (!child.delete()) {
                    JOptionPane.showMessageDialog(null, "Unable to empty simulation export folder. The operation was cancelled.", "Error", 0);
                    return;
                }
                ++n2;
            }
        } else {
            return;
        }
        try {
            SimulationExporter.ExportNet(project.getRoadNetwork(), sim.getExportPath(), sim.getName(), sim.isRoadNetworkSpeedInKMH());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while exporting road network", "Error", 0);
            e.printStackTrace();
            return;
        }
        if (sim.getExportPolygons()) {
            try {
                SimulationExporter.ExportPolygons(layersToExport, sim.getExportPath(), sim.getName());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while exporting element geometry", "Error", 0);
                e.printStackTrace();
                return;
            }
        }
        SUMOInstructionList<Trip> tripsList = new SUMOInstructionList<Trip>();
        SUMOInstructionList<Route> routesList = new SUMOInstructionList<Route>();
        SUMOInstructionList<Route> accidentRoutesList = new SUMOInstructionList<Route>();
        try {
            ArrayList<TrafficDefinitionElement> statisticalDefinitionElements = new ArrayList<TrafficDefinitionElement>();
            for (TrafficDefinitionLayer selectedLayer : layersToExport) {
                if (selectedLayer instanceof UserDefinedTrafficDefinitionLayer) {
                    TrafficGenerator.GenerateUserDefinedLayerTraffic(project.getRoadNetwork(), (UserDefinedTrafficDefinitionLayer)selectedLayer, tripsList, accidentRoutesList);
                    continue;
                }
                if (selectedLayer instanceof RandomTrafficDefinitionLayer) {
                    TrafficGenerator.GenerateRandomLayerTraffic(project.getRoadNetwork(), (RandomTrafficDefinitionLayer)selectedLayer, tripsList);
                    continue;
                }
                if (!(selectedLayer instanceof ActivityBasedTrafficDefinitionLayer)) continue;
                for (TrafficDefinitionElement e : selectedLayer.getElements()) {
                    if (!e.isEnabled()) continue;
                    statisticalDefinitionElements.add(e);
                }
            }
            TrafficGenerator.GenerateActivityBasedTraffic(project.getRoadNetwork(), project.getJobTypes(), project.getActivityBasedTrafficVehicleSelection(), statisticalDefinitionElements, tripsList, routesList);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while creating traffic for selected layers");
            e.printStackTrace();
            return;
        }
        if (tripsList.isEmpty() && routesList.isEmpty() && accidentRoutesList.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No trips or routes were generated");
        }
        Collections.sort(tripsList, new CustomComparator());
        Collections.sort(routesList, new CustomComparator());
        Collections.sort(accidentRoutesList, new CustomComparator());
        if (!tripsList.isEmpty()) {
            try {
                BufferedWriter tripout = new BufferedWriter(new FileWriter(String.valueOf(sim.getExportPath()) + File.separator + sim.getName() + ".generated-trips.xml"));
                tripout.write("<tripdefs>\n");
                for (VehicleType vehicleType : project.getVehicleTypes()) {
                    tripout.write(vehicleType.toXML());
                }
                tripout.write(tripsList.toString());
                tripout.write("</tripdefs>");
                tripout.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while writing trip file", "Error", 0);
                e.printStackTrace();
                return;
            }
        }
        if (!routesList.isEmpty()) {
            try {
                BufferedWriter routeout = new BufferedWriter(new FileWriter(String.valueOf(sim.getExportPath()) + File.separator + sim.getName() + ".generated-routes.xml"));
                routeout.write("<routes>\n");
                for (VehicleType vehicleType : project.getVehicleTypes()) {
                    routeout.write(vehicleType.toXML());
                }
                routeout.write(routesList.toString());
                routeout.write("</routes>");
                routeout.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while writing route file", "Error", 0);
                e.printStackTrace();
                return;
            }
        }
        if (!accidentRoutesList.isEmpty()) {
            try {
                BufferedWriter accidentRouteout = new BufferedWriter(new FileWriter(String.valueOf(sim.getExportPath()) + File.separator + sim.getName() + ".accidents.xml"));
                accidentRouteout.write("<routes>\n");
                if (routesList.isEmpty() && tripsList.isEmpty()) {
                    for (VehicleType vehicleType : project.getVehicleTypes()) {
                        accidentRouteout.write(vehicleType.toXML());
                    }
                }
                accidentRouteout.write(accidentRoutesList.toString());
                accidentRouteout.write("</routes>");
                accidentRouteout.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while writing accident routes file", "Error", 0);
                e.printStackTrace();
                return;
            }
        }
        if (!tripsList.isEmpty() || !routesList.isEmpty()) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("\"" + ApplicationSettings.getDUARouterPath() + "\"");
            if (!tripsList.isEmpty()) {
                args.add("-t=" + sim.getName() + "\".generated-trips.xml\"");
            }
            if (!routesList.isEmpty()) {
                args.add("-s=" + sim.getName() + "\".generated-routes.xml\"");
            }
            args.add("-n=" + sim.getName() + "\".net.xml\"");
            args.add("-o=" + sim.getName() + "\".rou.xml\"");
            args.add("--continue-on-unbuild");
            try {
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.directory(new File(sim.getExportPath()));
                Process dua = pb.start();
                StreamGobbler gi = new StreamGobbler(dua.getInputStream());
                StreamGobbler ge = new StreamGobbler(dua.getErrorStream());
                gi.start();
                ge.start();
                int exitvalue = dua.waitFor();
                gi.stop();
                ge.stop();
                List<String> gir = gi.getReadLines();
                List<String> ger = ge.getReadLines();
                for (String s : ger) {
                    System.out.println(s);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while generating routes from trips", "Error", 0);
                e.printStackTrace();
                return;
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(sim.getExportPath()) + File.separator + sim.getName() + ".sumo.cfg"));
            StringBuilder cfgBuilder = new StringBuilder();
            cfgBuilder.append("<configuration>\n");
            cfgBuilder.append("<input-files>\n");
            cfgBuilder.append("<net-file>" + sim.getName() + ".net.xml</net-file>\n");
            if (!(tripsList.isEmpty() && routesList.isEmpty() && accidentRoutesList.isEmpty())) {
                if (!(tripsList.isEmpty() && routesList.isEmpty() || !accidentRoutesList.isEmpty())) {
                    cfgBuilder.append("<route-files>");
                    cfgBuilder.append(String.valueOf(sim.getName()) + ".rou.xml");
                    cfgBuilder.append("</route-files>\n");
                } else if (tripsList.isEmpty() && routesList.isEmpty() && !accidentRoutesList.isEmpty()) {
                    cfgBuilder.append("<route-files>");
                    cfgBuilder.append(String.valueOf(sim.getName()) + ".accidents.xml");
                    cfgBuilder.append("</route-files>\n");
                } else {
                    cfgBuilder.append("<route-files>");
                    cfgBuilder.append(String.valueOf(sim.getName()) + ".rou.xml" + ";" + sim.getName() + ".accidents.xml");
                    cfgBuilder.append("</route-files>\n");
                }
            }
            if (sim.getExportPolygons()) {
                cfgBuilder.append("<additional-files>" + sim.getName() + ".geometry.xml</additional-files>\n");
            }
            cfgBuilder.append("</input-files>\n");
            cfgBuilder.append("<netstate-dump>" + sim.getName() + ".netdmp.xml</netstate-dump>\n");
            cfgBuilder.append("<simulation>\n");
            cfgBuilder.append("<begin>" + sim.getBeginTime() + "</begin>\n");
            cfgBuilder.append("<end>" + sim.getEndTime() + "</end>\n");
            cfgBuilder.append("</simulation>\n");
            cfgBuilder.append("</configuration>\n");
            out.write(cfgBuilder.toString());
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while writing simulation file", "Error", 0);
            e.printStackTrace();
            return;
        }
    }
}

