/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.ProjectElement;
import interfaces.DrawableElement;
import interfaces.HandleListener;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionLayer;

public abstract class TrafficDefinitionElement
extends ProjectElement
implements Serializable,
HandleListener,
DrawableElement {
    private static final long serialVersionUID = -8283034182313177579L;
    protected static int increment = 1;
    protected Hashtable<String, Handle> handles;
    protected String name = null;
    protected boolean exportPolygon = false;
    protected boolean enabled = true;
    protected TrafficDefinitionLayer layer = null;

    public TrafficDefinitionElement() {
        this.handles = new Hashtable();
    }

    protected TrafficDefinitionElement(TrafficDefinitionElement source) {
        this.name = source.name;
        this.handles = new Hashtable();
        for (Map.Entry<String, Handle> e : source.handles.entrySet()) {
            Handle h = new Handle(e.getValue());
            h.setHandleListener(this);
            this.handles.put(e.getKey(), h);
        }
        this.exportPolygon = source.exportPolygon;
    }

    public abstract TrafficDefinitionElement elementClone();

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        if (isSelected) {
            for (Handle handle : this.handles.values()) {
                handle.Draw(g);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Handle handleHit(Point p, AffineTransform tx) {
        for (Handle handle : this.handles.values()) {
            if (!handle.hit(p, tx)) continue;
            return handle;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    protected void addHandles(List<Handle> handles) {
        for (Handle h : handles) {
            this.handles.put(h.getName(), h);
            h.setHandleListener(this);
        }
    }

    public boolean getExportPolygon() {
        return this.exportPolygon;
    }

    public void setExportPolygon(boolean e) {
        this.exportPolygon = e;
    }

    public String getGeometryXML() {
        return "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract String toXML();

    public TrafficDefinitionLayer getLayer() {
        return this.layer;
    }

    public void setLayer(TrafficDefinitionLayer layer) {
        this.layer = layer;
    }
}

