/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.PseudoCylindricalProjection;
import java.awt.geom.Point2D;

public class BoggsProjection
extends PseudoCylindricalProjection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double FXC = 2.00276;
    private static final double FXC2 = 1.11072;
    private static final double FYC = 0.49931;
    private static final double FYC2 = 1.4142135623730951;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double theta = lpphi;
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) < 1.0E-7) {
            out.x = 0.0;
        } else {
            double c = Math.sin(theta) * Math.PI;
            for (int i = 20; i > 0; --i) {
                double th1 = (theta + Math.sin(theta) - c) / (1.0 + Math.cos(theta));
                theta -= th1;
                if (Math.abs(th1) < 1.0E-7) break;
            }
            out.x = 2.00276 * lplam / (1.0 / Math.cos(lpphi) + 1.11072 / Math.cos(theta *= 0.5));
        }
        out.y = 0.49931 * (lpphi + 1.4142135623730951 * Math.sin(theta));
        return out;
    }

    public boolean isEqualArea() {
        return true;
    }

    public boolean hasInverse() {
        return false;
    }

    public String toString() {
        return "Boggs Eumorphic";
    }
}

