/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.ConicProjection;
import com.jhlabs.map.proj.Ellipsoid;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class LambertConformalConicProjection
extends ConicProjection {
    private double n;
    private double rho0;
    private double c;

    public LambertConformalConicProjection() {
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLatitude = 0.7853981633974483;
        this.projectionLatitude1 = 0.0;
        this.projectionLatitude2 = 0.0;
        this.initialize();
    }

    public LambertConformalConicProjection(Ellipsoid ellipsoid, double lon_0, double lat_1, double lat_2, double lat_0, double x_0, double y_0) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = lon_0;
        this.projectionLatitude = lat_0;
        this.scaleFactor = 1.0;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.projectionLatitude1 = lat_1;
        this.projectionLatitude2 = lat_2;
        this.initialize();
    }

    public Point2D.Double project(double x, double y, Point2D.Double out) {
        double rho = Math.abs(Math.abs(y) - 1.5707963267948966) < 1.0E-10 ? 0.0 : this.c * (this.spherical ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * y), -this.n) : Math.pow(MapMath.tsfn(y, Math.sin(y), this.e), this.n));
        out.x = this.scaleFactor * (rho * Math.sin(x *= this.n));
        out.y = this.scaleFactor * (this.rho0 - rho * Math.cos(x));
        return out;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double out) {
        y /= this.scaleFactor;
        double rho = MapMath.distance(x /= this.scaleFactor, y = this.rho0 - y);
        if (rho != 0.0) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            out.y = this.spherical ? 2.0 * Math.atan(Math.pow(this.c / rho, 1.0 / this.n)) - 1.5707963267948966 : MapMath.phi2(Math.pow(rho / this.c, 1.0 / this.n), this.e);
            out.x = Math.atan2(x, y) / this.n;
        } else {
            out.x = 0.0;
            out.y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return out;
    }

    public void initialize() {
        double sinphi;
        super.initialize();
        if (this.projectionLatitude1 == 0.0) {
            this.projectionLatitude1 = this.projectionLatitude2 = this.projectionLatitude;
        }
        if (Math.abs(this.projectionLatitude1 + this.projectionLatitude2) < 1.0E-10) {
            throw new ProjectionException();
        }
        this.n = sinphi = Math.sin(this.projectionLatitude1);
        double cosphi = Math.cos(this.projectionLatitude1);
        boolean secant = Math.abs(this.projectionLatitude1 - this.projectionLatitude2) >= 1.0E-10;
        boolean bl = this.spherical = this.es == 0.0;
        if (!this.spherical) {
            double m1 = MapMath.msfn(sinphi, cosphi, this.es);
            double ml1 = MapMath.tsfn(this.projectionLatitude1, sinphi, this.e);
            if (secant) {
                sinphi = Math.sin(this.projectionLatitude2);
                this.n = Math.log(m1 / MapMath.msfn(sinphi, Math.cos(this.projectionLatitude2), this.es));
                this.n /= Math.log(ml1 / MapMath.tsfn(this.projectionLatitude2, sinphi, this.e));
            }
            this.c = this.rho0 = m1 * Math.pow(ml1, -this.n) / this.n;
            this.rho0 *= Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10 ? 0.0 : Math.pow(MapMath.tsfn(this.projectionLatitude, Math.sin(this.projectionLatitude), this.e), this.n);
        } else {
            if (secant) {
                this.n = Math.log(cosphi / Math.cos(this.projectionLatitude2)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude2) / Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude1));
            }
            this.c = cosphi * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude1), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10 ? 0.0 : this.c * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude), -this.n);
        }
    }

    public boolean isConformal() {
        return true;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Lambert Conformal Conic";
    }
}

