/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import roadnetwork.Edge;
import roadnetwork.Junction;
import roadnetwork.Lane;
import roadnetwork.RoadNetwork;
import shapes.Point2DExt;

public class RoadNetworkParser {
    public RoadNetwork ParseXMLNetFile(Document roadNetworkXMLDocument) throws Exception {
        RoadNetwork net = new RoadNetwork();
        Element docel = roadNetworkXMLDocument.getDocumentElement();
        NodeList edges = docel.getElementsByTagName("edge");
        List<Edge> parsedEdges = this.ParseEdges(edges);
        net.AddElements(parsedEdges);
        NodeList junctions = docel.getElementsByTagName("junction");
        List<Junction> parsedJunctions = this.ParseJunctions(junctions);
        net.AddElements(parsedJunctions);
        return net;
    }

    private List<Edge> ParseEdges(NodeList xmlEdgeNodes) {
        ArrayList<Edge> parsedEdges = new ArrayList<Edge>();
        int totalEdges = xmlEdgeNodes.getLength();
        int i = 0;
        while (i < totalEdges) {
            Node edge = xmlEdgeNodes.item(i);
            NamedNodeMap edgeAttributes = edge.getAttributes();
            Node function = edgeAttributes.getNamedItem("function");
            if (function.getNodeValue().equals("normal")) {
                Edge e = new Edge();
                e.setId(edgeAttributes.getNamedItem("id").getNodeValue());
                e.setLength(Float.parseFloat(edgeAttributes.getNamedItem("Length").getNodeValue()));
                e.setSpeedLimit(Float.parseFloat(edgeAttributes.getNamedItem("Speed").getNodeValue()));
                e.setFrom(edgeAttributes.getNamedItem("from").getNodeValue());
                e.setTo(edgeAttributes.getNamedItem("to").getNodeValue());
                e.setPriority(Integer.parseInt(edgeAttributes.getNamedItem("Priority").getNodeValue()));
                NodeList lanes = ((Element)edge).getElementsByTagName("lane");
                int totalLanes = lanes.getLength();
                int j = 0;
                while (j < totalLanes) {
                    String[] coords;
                    Node lane = lanes.item(j);
                    Lane l = new Lane();
                    NamedNodeMap laneAttributes = lane.getAttributes();
                    l.setId(laneAttributes.getNamedItem("id").getNodeValue());
                    ArrayList<Point2DExt> points = new ArrayList<Point2DExt>();
                    String[] stringArray = coords = lane.getTextContent().split(" ");
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String coord = stringArray[n];
                        String[] from = coord.split(",");
                        double fromx = Double.parseDouble(from[0]);
                        double fromy = Double.parseDouble(from[1]);
                        points.add(new Point2DExt(fromx, fromy));
                        ++n;
                    }
                    l.SetShape(points);
                    e.AddLane(l);
                    ++j;
                }
                NodeList connectedEdges = ((Element)edge).getElementsByTagName("cedge");
                int totalConnectedEdges = connectedEdges.getLength();
                int k = 0;
                while (k < totalConnectedEdges) {
                    Node connectedEdge = connectedEdges.item(k);
                    String connectedEdgeID = connectedEdge.getAttributes().getNamedItem("id").getNodeValue();
                    String laneID = connectedEdge.getTextContent();
                    for (Lane l : e.getLanes()) {
                        if (!l.getId().equals(laneID)) continue;
                        l.AddConnectedEdge(connectedEdgeID);
                    }
                    ++k;
                }
                e.CalculateShape();
                parsedEdges.add(e);
            }
            ++i;
        }
        return parsedEdges;
    }

    private List<Junction> ParseJunctions(NodeList xmlJunctionNodes) {
        ArrayList<Junction> parsedJunctions = new ArrayList<Junction>();
        int totalJunctions = xmlJunctionNodes.getLength();
        int i = 0;
        while (i < totalJunctions) {
            Node junction = xmlJunctionNodes.item(i);
            NamedNodeMap junctionAttributes = junction.getAttributes();
            Node function = junctionAttributes.getNamedItem("type");
            if (!function.getNodeValue().equals("internal")) {
                Junction j = new Junction();
                j.setId(junctionAttributes.getNamedItem("id").getNodeValue());
                j.setType(junctionAttributes.getNamedItem("type").getNodeValue());
                String coordinates = ((Element)junction).getElementsByTagName("shape").item(0).getTextContent();
                if (coordinates.equals("")) {
                    j.SetShape(null);
                } else {
                    String[] coords = ((Element)junction).getElementsByTagName("shape").item(0).getTextContent().split(" ");
                    ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
                    if (coords.length > 0 && coords[0] != "") {
                        String[] stringArray = coords;
                        int n = 0;
                        int n2 = stringArray.length;
                        while (n < n2) {
                            String coord = stringArray[n];
                            String[] from = coord.split(",");
                            float fromx = Float.parseFloat(from[0]);
                            float fromy = Float.parseFloat(from[1]);
                            points.add(new Point2D.Float(fromx, fromy));
                            ++n;
                        }
                    }
                    j.SetShape(points);
                }
                parsedJunctions.add(j);
            }
            ++i;
        }
        return parsedJunctions;
    }
}

