/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.filemode;

import freemind.controller.StructuredMenuHolder;
import freemind.extensions.HookFactory;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.common.actions.NewMapAction;
import freemind.modes.filemode.FileMapModel;
import freemind.modes.filemode.FileNodeModel;
import freemind.modes.filemode.FilePopupMenu;
import freemind.modes.viewmodes.ViewControllerAdapter;
import freemind.view.mindmapview.MainView;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class FileController
extends ViewControllerAdapter {
    Action newMap = new NewMapAction(this);
    Action center = new CenterAction();
    Action openPath = new OpenPathAction();
    private JPopupMenu popupmenu = new FilePopupMenu(this);

    public FileController(Mode mode) {
        super(mode);
    }

    public MapAdapter newModel(ModeController modeController) {
        return new FileMapModel(this.getFrame(), modeController);
    }

    public MindMapNode newNode(Object userObject, MindMap map) {
        return new FileNodeModel((File)userObject, this.getFrame(), map);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void updateMenus(StructuredMenuHolder holder) {
        this.add(holder, "menu_bar/edit//find", this.find, "keystroke_find");
        this.add(holder, "menu_bar/edit//findNext", this.findNext, "keystroke_find_next");
        this.add(holder, "menu_bar/edit//openPath", this.openPath, null);
    }

    public HookFactory getHookFactory() {
        throw new IllegalArgumentException("Not implemented yet.");
    }

    public void plainClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MainView component = (MainView)e.getComponent();
        if (component.isInFollowLinkRegion(e.getX())) {
            this.loadURL();
        } else {
            MindMapNode node = component.getNodeView().getModel();
            this.toggleFolded(node);
        }
    }

    private void toggleFolded(MindMapNode node) {
        if (node.hasChildren() && !node.isRoot()) {
            this.setFolded(node, !node.isFolded());
        }
    }

    private class OpenPathAction
    extends AbstractAction {
        OpenPathAction() {
            super(FileController.this.getController().getResourceString("open"));
        }

        public void actionPerformed(ActionEvent e) {
            File newCenter;
            String inputValue = JOptionPane.showInputDialog(FileController.this.getController().getView().getSelected(), FileController.this.getText("open"), "");
            if (inputValue != null && (newCenter = new File(inputValue)).exists()) {
                FileMapModel map = new FileMapModel(newCenter, FileController.this.getFrame(), FileController.this);
                FileController.this.newMap(map);
            }
        }
    }

    private class CenterAction
    extends AbstractAction {
        CenterAction() {
            super(FileController.this.getController().getResourceString("center"));
        }

        public void actionPerformed(ActionEvent e) {
            if (FileController.this.getSelected() != null) {
                FileMapModel map = new FileMapModel(((FileNodeModel)FileController.this.getSelected()).getFile(), FileController.this.getFrame(), FileController.this);
                FileController.this.newMap(map);
            }
        }
    }
}

