/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.FoldAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.common.CommonToggleFoldedAction;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class ToggleFoldedAction
extends AbstractAction
implements ActorXml {
    private final MindMapController modeController;
    private Logger logger;

    public ToggleFoldedAction(MindMapController controller) {
        super(controller.getText("toggle_folded"));
        this.modeController = controller;
        this.modeController.getActionFactory().registerActor(this, this.getDoActionClass());
        this.logger = this.modeController.getFrame().getLogger(this.getClass().getName());
    }

    public void actionPerformed(ActionEvent e) {
        this.toggleFolded();
    }

    public void toggleFolded() {
        this.toggleFolded(this.modeController.getSelecteds().listIterator());
    }

    public void toggleFolded(ListIterator listIterator) {
        boolean fold = CommonToggleFoldedAction.getFoldingState(CommonToggleFoldedAction.reset(listIterator));
        CompoundAction doAction = this.createFoldAction(CommonToggleFoldedAction.reset(listIterator), fold, false);
        CompoundAction undoAction = this.createFoldAction(CommonToggleFoldedAction.reset(listIterator), !fold, true);
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private CompoundAction createFoldAction(ListIterator iterator, boolean fold, boolean undo) {
        CompoundAction comp = new CompoundAction();
        MindMapNode lastNode = null;
        ListIterator it = iterator;
        while (it.hasNext()) {
            MindMapNode node = (MindMapNode)it.next();
            FoldAction foldAction = this.createSingleFoldAction(fold, node, undo);
            if (foldAction == null) continue;
            if (!undo) {
                comp.addChoice((Object)foldAction);
            } else {
                comp.addAtChoice(0, (Object)foldAction);
            }
            lastNode = node;
        }
        this.logger.finest("Compound contains " + comp.sizeChoiceList() + " elements.");
        return comp;
    }

    private FoldAction createSingleFoldAction(boolean fold, MindMapNode node, boolean undo) {
        FoldAction foldAction = null;
        if ((undo && node.isFolded() == fold || !undo && node.isFolded() != fold) && (node.hasChildren() || Tools.safeEquals(this.modeController.getFrame().getProperty("enable_leaves_folding"), "true"))) {
            foldAction = new FoldAction();
            foldAction.setFolded(fold);
            foldAction.setNode(this.modeController.getNodeID(node));
        }
        return foldAction;
    }

    public void act(XmlAction action) {
        if (action instanceof FoldAction) {
            FoldAction foldAction = (FoldAction)action;
            NodeAdapter node = this.modeController.getNodeFromID(foldAction.getNode());
            boolean fold = foldAction.getFolded();
            this.modeController._setFolded(node, fold);
            if (Resources.getInstance().getBoolProperty("resources_save_folding_state")) {
                this.modeController.nodeChanged(node);
            }
        }
    }

    public Class getDoActionClass() {
        return FoldAction.class;
    }

    public void setFolded(MindMapNode node, boolean folded) {
        FoldAction doAction = this.createSingleFoldAction(folded, node, false);
        FoldAction undoAction = this.createSingleFoldAction(!folded, node, true);
        if (doAction == null || undoAction == null) {
            return;
        }
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }
}

