/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.listeners;

import freemind.controller.NodeMotionListener;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class MindMapNodeMotionListener
extends NodeMotionListener.NodeMotionAdapter {
    private final MindMapController c;
    private static Logger logger;
    private Point dragStartingPoint = null;
    private int originalParentVGap;
    private int originalHGap;
    private int originalShiftY;

    public MindMapNodeMotionListener(MindMapController controller) {
        this.c = controller;
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        logger.fine("Event: mouseDragged");
        if ((e.getModifiersEx() & 0x400) == 1024) {
            final NodeMotionListenerView motionListenerView = (NodeMotionListenerView)e.getSource();
            NodeView nodeV = this.getNodeView(e);
            final MapView mapView = nodeV.getMap();
            Point point = e.getPoint();
            Tools.convertPointToAncestor((Component)motionListenerView, point, JScrollPane.class);
            if (!this.isActive()) {
                this.setDragStartingPoint(point, nodeV.getModel());
            } else {
                Point dragNextPoint = point;
                if ((e.getModifiersEx() & 0x80) == 0) {
                    MindMapNode node = nodeV.getModel();
                    node.setShiftY(this.getNodeShiftY(dragNextPoint, node, this.dragStartingPoint));
                    node.setHGap(this.getHGap(dragNextPoint, node, this.dragStartingPoint));
                    this.c.getModeController().nodeRefresh(node);
                } else {
                    MindMapNode parentNode = nodeV.getVisibleParentView().getModel();
                    parentNode.setVGap(this.getVGap(dragNextPoint, parentNode, this.dragStartingPoint));
                    this.c.getModel().nodeRefresh(parentNode);
                    this.c.getModel().nodeRefresh(nodeV.getModel());
                }
                this.dragStartingPoint = point;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Rectangle r = motionListenerView.getBounds();
                    boolean isEventPointVisible = mapView.getVisibleRect().contains(r);
                    if (!isEventPointVisible) {
                        mapView.scrollRectToVisible(r);
                    }
                }
            });
        }
    }

    private int getVGap(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int oldVGap = node.getVGap();
        int vGapChange = (int)((float)(dragNextPoint.y - dragStartingPoint.y) / this.c.getView().getZoom());
        oldVGap = Math.max(0, oldVGap - vGapChange);
        return oldVGap;
    }

    private int getHGap(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int oldHGap = node.getHGap();
        int hGapChange = (int)((float)(dragNextPoint.x - dragStartingPoint.x) / this.c.getView().getZoom());
        if (node.isLeft()) {
            hGapChange = -hGapChange;
        }
        return oldHGap += hGapChange;
    }

    private int getNodeShiftY(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int shiftY = node.getShiftY();
        int shiftYChange = (int)((float)(dragNextPoint.y - dragStartingPoint.y) / this.c.getView().getZoom());
        return shiftY += shiftYChange;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getModifiersEx() == 0) {
                NodeView nodeV = this.getNodeView(e);
                MindMapNode node = nodeV.getModel();
                this.c.moveNodePosition(node, node.getVGap(), 20, 0);
                return;
            }
            if (e.getModifiersEx() == 128) {
                NodeView nodeV = this.getNodeView(e);
                MindMapNode node = nodeV.getModel();
                this.c.moveNodePosition(node, 3, node.getHGap(), node.getShiftY());
                return;
            }
        }
    }

    private NodeView getNodeView(MouseEvent e) {
        return ((NodeMotionListenerView)e.getSource()).getMovedView();
    }

    public void mouseEntered(MouseEvent e) {
        logger.fine("Event: mouseEntered");
        if (!JOptionPane.getFrameForComponent(e.getComponent()).isFocused()) {
            return;
        }
        if (!this.isActive()) {
            NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
            v.setMouseEntered();
        }
    }

    public void mouseExited(MouseEvent e) {
        logger.fine("Event: mouseExited");
        if (!this.isActive()) {
            NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
            v.setMouseExited();
        }
    }

    private void stopDrag() {
        this.setDragStartingPoint(null, null);
    }

    public void mouseReleased(MouseEvent e) {
        logger.fine("Event: mouseReleased");
        NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
        if (!v.contains(e.getX(), e.getY())) {
            v.setMouseExited();
        }
        if (!this.isActive()) {
            return;
        }
        NodeView nodeV = this.getNodeView(e);
        Point point = e.getPoint();
        Tools.convertPointToAncestor((Component)nodeV, point, JScrollPane.class);
        MindMapNode node = nodeV.getModel();
        MindMapNode parentNode = nodeV.getModel().getParentNode();
        int parentVGap = parentNode.getVGap();
        int hgap = node.getHGap();
        int shiftY = node.getShiftY();
        this.resetPositions(node);
        this.c.moveNodePosition(node, parentVGap, hgap, shiftY);
        this.stopDrag();
    }

    private void resetPositions(MindMapNode node) {
        node.getParentNode().setVGap(this.originalParentVGap);
        node.setHGap(this.originalHGap);
        node.setShiftY(this.originalShiftY);
    }

    public boolean isActive() {
        return this.getDragStartingPoint() != null;
    }

    void setDragStartingPoint(Point point, MindMapNode node) {
        this.dragStartingPoint = point;
        if (point != null) {
            this.originalParentVGap = node.getParentNode().getVGap();
            this.originalHGap = node.getHGap();
            this.originalShiftY = node.getShiftY();
        } else {
            this.originalShiftY = 0;
            this.originalHGap = 0;
            this.originalParentVGap = 0;
        }
    }

    Point getDragStartingPoint() {
        return this.dragStartingPoint;
    }
}

