/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.util;

import freemind.controller.filter.util.SortedListModel;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExtendedComboBoxModel
extends DefaultComboBoxModel {
    private SortedListModel extension = null;
    private ExtensionDataListener extensionDataListener = new ExtensionDataListener();

    public void setExtensionList(SortedListModel sortedListModel) {
        int extensionSize;
        int ownSize = this.getOwnSize();
        if (this.extension != null) {
            this.extension.removeListDataListener(this.extensionDataListener);
            extensionSize = this.getExtensionSize();
            if (extensionSize > 0) {
                this.fireIntervalRemoved(this, ownSize, ownSize + extensionSize - 1);
            }
        }
        this.extension = sortedListModel;
        extensionSize = this.getExtensionSize();
        if (extensionSize > 0) {
            this.fireIntervalAdded(this, ownSize, ownSize + extensionSize - 1);
        }
        if (this.extension != null) {
            this.extension.addListDataListener(this.extensionDataListener);
        }
    }

    public ExtendedComboBoxModel() {
    }

    public ExtendedComboBoxModel(Object[] o) {
        super(o);
    }

    public ExtendedComboBoxModel(Vector v) {
        super(v);
    }

    public Object getElementAt(int i) {
        int s = this.getOwnSize();
        if (i < s || this.extension == null) {
            return super.getElementAt(i);
        }
        return this.extension.getElementAt(i - s);
    }

    public int getSize() {
        return this.getOwnSize() + this.getExtensionSize();
    }

    private int getExtensionSize() {
        return this.extension != null ? this.extension.getSize() : 0;
    }

    private int getOwnSize() {
        return super.getSize();
    }

    private ExtendedComboBoxModel getModel() {
        return this;
    }

    public void insertElementAt(Object o, int i) {
        super.insertElementAt(o, Math.min(this.getOwnSize(), i));
    }

    public void removeAllElements() {
        super.removeAllElements();
        if (this.extension != null) {
            this.extension.clear();
        }
    }

    public void removeElement(Object o) {
        super.removeElement(o);
    }

    public void removeElementAt(int i) {
        if (i < this.getOwnSize()) {
            super.removeElementAt(i);
        }
    }

    public void addSortedElement(Object o) {
        if (this.extension != null && !this.extension.contains(o)) {
            this.extension.add(o);
        }
    }

    public int getIndexOf(Object o) {
        int idx = super.getIndexOf(o);
        if (idx > -1 || this.extension == null) {
            return idx;
        }
        int extIdx = this.extension.getIndexOf(o);
        return extIdx > -1 ? extIdx + this.getOwnSize() : -1;
    }

    private class ExtensionDataListener
    implements ListDataListener {
        private ExtensionDataListener() {
        }

        public void intervalAdded(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireIntervalAdded(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireIntervalRemoved(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }

        public void contentsChanged(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireContentsChanged(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }
    }
}

