/*
 * Decompiled with CFR 0.152.
 */
package freemind.preferences.layout;

import freemind.main.FreeMindMain;
import freemind.preferences.layout.KeyEventTranslator;
import freemind.preferences.layout.KeyEventWorkaround;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class GrabKeyDialog
extends JDialog {
    private final FreeMindMain fmMain;
    private InputPane shortcut;
    private JLabel assignedTo;
    private JButton ok;
    private JButton remove;
    private JButton cancel;
    private JButton clear;
    private boolean isOK;
    private KeyBinding binding;
    private Vector allBindings;
    private Buffer debugBuffer;
    private int modifierMask;
    public static final String MODIFIER_SEPARATOR = " ";

    public static String toString(KeyEvent evt) {
        String id;
        switch (evt.getID()) {
            case 401: {
                id = "KEY_PRESSED";
                break;
            }
            case 402: {
                id = "KEY_RELEASED";
                break;
            }
            case 400: {
                id = "KEY_TYPED";
                break;
            }
            default: {
                id = "unknown type";
            }
        }
        return id + ",keyCode=0x" + Integer.toString(evt.getKeyCode(), 16) + ",keyChar=0x" + Integer.toString(evt.getKeyChar(), 16) + ",modifiers=0x" + Integer.toString(evt.getModifiers(), 16);
    }

    public GrabKeyDialog(FreeMindMain fmMain, Dialog parent, KeyBinding binding, Vector allBindings, Buffer debugBuffer) {
        this(fmMain, parent, binding, allBindings, debugBuffer, 0);
    }

    public GrabKeyDialog(FreeMindMain fmMain, Dialog parent, KeyBinding binding, Vector allBindings, Buffer debugBuffer, int modifierMask) {
        super(parent, "grab-key.title", true);
        this.fmMain = fmMain;
        this.modifierMask = modifierMask;
        this.setTitle(this.getText("grab-key.title"));
        this.init(binding, allBindings, debugBuffer);
    }

    public String getShortcut() {
        if (this.isOK) {
            return this.shortcut.getText();
        }
        return null;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    protected void processKeyEvent(KeyEvent evt) {
        this.shortcut.processKeyEvent(evt);
    }

    private void init(KeyBinding binding, Vector allBindings, Buffer debugBuffer) {
        this.binding = binding;
        this.allBindings = allBindings;
        this.debugBuffer = debugBuffer;
        this.enableEvents(8L);
        JPanel content = new JPanel(new GridLayout(0, 1, 0, 6)){

            public boolean isManagingFocus() {
                return false;
            }

            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        };
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JLabel label = new JLabel(debugBuffer == null ? this.getText("grab-key.caption") + MODIFIER_SEPARATOR + binding.label : this.getText("grab-key.keyboard-test"));
        Box input = Box.createHorizontalBox();
        this.shortcut = new InputPane();
        input.add(this.shortcut);
        input.add(Box.createHorizontalStrut(12));
        this.clear = new JButton(this.getText("grab-key.clear"));
        this.clear.addActionListener(new ActionHandler());
        input.add(this.clear);
        this.assignedTo = new JLabel();
        if (debugBuffer == null) {
            this.updateAssignedTo(null);
        }
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createGlue());
        if (debugBuffer == null) {
            this.ok = new JButton(this.getText("common.ok"));
            this.ok.addActionListener(new ActionHandler());
            buttons.add(this.ok);
            buttons.add(Box.createHorizontalStrut(12));
            if (binding.isAssigned()) {
                this.remove = new JButton(this.getText("grab-key.remove"));
                this.remove.addActionListener(new ActionHandler());
                buttons.add(Box.createHorizontalStrut(12));
            }
        }
        this.cancel = new JButton(this.getText("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add(input);
        content.add(buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.setVisible(true);
    }

    private String getSymbolicName(int keyCode) {
        if (keyCode == 0) {
            return null;
        }
        if (keyCode >= 65 && keyCode <= 90) {
            return String.valueOf(Character.toLowerCase((char)keyCode));
        }
        try {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                if (!name.startsWith("VK_") || field.getInt(null) != keyCode) continue;
                return name.substring(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void updateAssignedTo(String shortcut) {
        String text = this.getText("grab-key.assigned-to.none");
        KeyBinding kb = this.getKeyBinding(shortcut);
        if (kb != null) {
            text = kb.isPrefix ? this.getText("grab-key.assigned-to.prefix") + MODIFIER_SEPARATOR + shortcut : kb.label;
        }
        if (this.ok != null) {
            this.ok.setEnabled(kb == null || !kb.isPrefix);
        }
        this.assignedTo.setText(this.getText("grab-key.assigned-to") + MODIFIER_SEPARATOR + text);
    }

    private KeyBinding getKeyBinding(String shortcut) {
        if (shortcut == null || shortcut.length() == 0) {
            return null;
        }
        String spacedShortcut = shortcut + MODIFIER_SEPARATOR;
        Enumeration e = this.allBindings.elements();
        while (e.hasMoreElements()) {
            KeyBinding kb = (KeyBinding)e.nextElement();
            if (!kb.isAssigned()) continue;
            String spacedKbShortcut = kb.shortcut + MODIFIER_SEPARATOR;
            if (spacedShortcut.startsWith(spacedKbShortcut)) {
                return kb;
            }
            if (!spacedKbShortcut.startsWith(spacedShortcut)) continue;
            return new KeyBinding(kb.name, kb.label, shortcut, true);
        }
        return null;
    }

    private String getText(String resourceString) {
        return this.fmMain.getResourceString("GrabKeyDialog." + resourceString);
    }

    private int getModifierMask() {
        return this.modifierMask;
    }

    public static boolean isMacOS() {
        return false;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GrabKeyDialog.this.ok) {
                if (this.canClose()) {
                    GrabKeyDialog.this.dispose();
                }
            } else if (evt.getSource() == GrabKeyDialog.this.remove) {
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.isOK = true;
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.cancel) {
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.clear) {
                GrabKeyDialog.this.shortcut.setText(null);
                if (GrabKeyDialog.this.debugBuffer == null) {
                    GrabKeyDialog.this.updateAssignedTo(null);
                }
                GrabKeyDialog.this.shortcut.requestFocus();
            }
        }

        private boolean canClose() {
            KeyBinding other;
            String shortcutString = GrabKeyDialog.this.shortcut.getText();
            if (shortcutString.length() == 0 && GrabKeyDialog.this.binding.isAssigned()) {
                int answer = JOptionPane.showConfirmDialog(GrabKeyDialog.this, GrabKeyDialog.this.getText("grab-key.remove-ask"), null, 0, 3);
                if (answer == 0) {
                    GrabKeyDialog.this.shortcut.setText(null);
                    GrabKeyDialog.this.isOK = true;
                } else {
                    return false;
                }
            }
            if ((other = GrabKeyDialog.this.getKeyBinding(shortcutString)) == null || other == GrabKeyDialog.this.binding) {
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            if (other.name == ((GrabKeyDialog)GrabKeyDialog.this).binding.name) {
                JOptionPane.showMessageDialog(GrabKeyDialog.this, GrabKeyDialog.this.getText("grab-key.duplicate-alt-shortcut"));
                return false;
            }
            if (other.isPrefix) {
                JOptionPane.showMessageDialog(GrabKeyDialog.this, GrabKeyDialog.this.getText("grab-key.prefix-shortcut"));
                return false;
            }
            int answer = JOptionPane.showConfirmDialog(GrabKeyDialog.this, GrabKeyDialog.this.getText("grab-key.duplicate-shortcut") + new Object[]{other.label}, null, 0, 3);
            if (answer == 0) {
                if (other.shortcut != null && shortcutString.startsWith(other.shortcut)) {
                    other.shortcut = null;
                }
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            return false;
        }
    }

    class InputPane
    extends JTextField {
        InputPane() {
        }

        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        protected void processKeyEvent(KeyEvent _evt) {
            if ((GrabKeyDialog.this.getModifierMask() & _evt.getModifiers()) != 0) {
                KeyEvent evt = new KeyEvent(_evt.getComponent(), _evt.getID(), _evt.getWhen(), ~GrabKeyDialog.this.getModifierMask() & _evt.getModifiers(), _evt.getKeyCode(), _evt.getKeyChar(), _evt.getKeyLocation());
                this.processKeyEvent(evt);
                if (evt.isConsumed()) {
                    _evt.consume();
                }
                return;
            }
            KeyEvent evt = KeyEventWorkaround.processKeyEvent(_evt);
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "Event " + GrabKeyDialog.toString(_evt) + (evt == null ? " filtered\n" : " passed\n"));
            }
            if (evt == null) {
                return;
            }
            evt.consume();
            KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(evt);
            if (key == null) {
                return;
            }
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "==> Translated to " + key + "\n");
            }
            StringBuffer keyString = new StringBuffer();
            if (key.modifiers != null) {
                keyString.append(key.modifiers).append(' ');
            }
            if (key.input == ' ') {
                keyString.append("SPACE");
            } else if (key.input != '\u0000') {
                keyString.append(key.input);
            } else {
                String symbolicName = GrabKeyDialog.this.getSymbolicName(key.key);
                if (symbolicName == null) {
                    return;
                }
                keyString.append(symbolicName);
            }
            this.setText(keyString.toString());
            if (GrabKeyDialog.this.debugBuffer == null) {
                GrabKeyDialog.this.updateAssignedTo(keyString.toString());
            }
        }
    }

    public static class KeyBinding {
        public String name;
        public String label;
        public String shortcut;
        public boolean isPrefix;

        public KeyBinding(String name, String label, String shortcut, boolean isPrefix) {
            this.name = name;
            this.label = label;
            this.shortcut = shortcut;
            this.isPrefix = isPrefix;
        }

        public boolean isAssigned() {
            return this.shortcut != null && this.shortcut.length() > 0;
        }
    }

    private static class Buffer {
        private Buffer() {
        }

        public int getLength() {
            return 0;
        }

        public void insert(int length, String string) {
        }
    }
}

