/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.dialogs;

import freemind.common.TextTranslator;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.Tools;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.dialogs.StylePatternFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ChooseFormatPopupDialog
extends JDialog
implements TextTranslator,
KeyListener {
    public static final int CANCEL = -1;
    public static final int OK = 1;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = "accessories.plugins.dialogs.ChooseFormatPopupDialog.window_storage";
    private int result = -1;
    private JPanel jContentPane = null;
    private MindMapController mController;
    private JButton jCancelButton;
    private JButton jOKButton;
    private StylePatternFrame mStylePatternFrame;

    public ChooseFormatPopupDialog(JFrame caller, MindMapController controller, String dialogTitle, Pattern pattern) {
        super(caller);
        this.mController = controller;
        this.initialize(dialogTitle);
        this.mStylePatternFrame.setPattern(pattern);
        this.mStylePatternFrame.addListeners();
    }

    private void initialize(String dialogTitle) {
        this.setTitle(this.mController.getText(dialogTitle));
        JPanel contentPane = this.getJContentPane();
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ChooseFormatPopupDialog.this.cancelPressed();
            }
        });
        this.addKeyListener(this);
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                ChooseFormatPopupDialog.this.cancelPressed();
            }
        };
        Tools.addEscapeActionToDialog(this, action);
        this.pack();
        this.mController.decorateDialog(this, WINDOW_PREFERENCE_STORAGE_PROPERTY);
    }

    private void close() {
        WindowConfigurationStorage storage = new WindowConfigurationStorage();
        this.mController.storeDialogPositions(this, storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.setVisible(false);
        this.dispose();
    }

    private void okPressed() {
        this.result = 1;
        this.close();
    }

    private void cancelPressed() {
        this.result = -1;
        this.close();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)new JScrollPane(this.getStylePatternFrame()), new GridBagConstraints(0, 0, 2, 1, 2.0, 8.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jContentPane.add((Component)this.getJOKButton(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jContentPane.add((Component)this.getJCancelButton(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getRootPane().setDefaultButton(this.getJOKButton());
        }
        return this.jContentPane;
    }

    private Component getStylePatternFrame() {
        if (this.mStylePatternFrame == null) {
            this.mStylePatternFrame = new StylePatternFrame(this, this.mController, StylePatternFrame.StylePatternFrameType.WITHOUT_NAME_AND_CHILDS);
            this.mStylePatternFrame.init();
        }
        return this.mStylePatternFrame;
    }

    private JButton getJOKButton() {
        if (this.jOKButton == null) {
            this.jOKButton = new JButton();
            this.jOKButton.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ChooseFormatPopupDialog.this.okPressed();
                }
            });
            Tools.setLabelAndMnemonic(this.jOKButton, this.mController.getText("ok"));
        }
        return this.jOKButton;
    }

    private JButton getJCancelButton() {
        if (this.jCancelButton == null) {
            this.jCancelButton = new JButton();
            this.jCancelButton.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ChooseFormatPopupDialog.this.cancelPressed();
                }
            });
            Tools.setLabelAndMnemonic(this.jCancelButton, this.mController.getText("cancel"));
        }
        return this.jCancelButton;
    }

    public int getResult() {
        return this.result;
    }

    public String getText(String pKey) {
        return this.mController.getText(pKey);
    }

    public Pattern getPattern() {
        return this.mStylePatternFrame.getResultPattern();
    }

    public Pattern getPattern(Pattern copyIntoPattern) {
        return this.mStylePatternFrame.getResultPattern(copyIntoPattern);
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.out.println("key pressed: " + keyEvent);
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.cancelPressed();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.out.println("keyReleased: " + keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        System.out.println("keyTyped: " + keyEvent);
    }
}

