/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionFactory;
import freemind.controller.filter.condition.NodeCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.NodeAttributeTableModel;

public class AttributeExistsCondition
extends NodeCondition {
    static final String ATTRIBUTE = "attribute";
    static final String NAME = "attribute_exists_condition";
    private String attribute;

    public AttributeExistsCondition(String attribute) {
        this.attribute = attribute;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        NodeAttributeTableModel attributes = node.getAttributes();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            return true;
        }
        return false;
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        super.saveAttributes(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new AttributeExistsCondition(element.getStringAttribute(ATTRIBUTE));
    }

    protected String createDesctiption() {
        String simpleCondition = Resources.getInstance().getResourceString("filter_exist");
        return ConditionFactory.createDescription(this.attribute, simpleCondition, null, false);
    }
}

