REM Applies Scaled with Image attributes to all objects in Drawing.
REM  30-Mar-1998 by Alex I. Vakulenko
REM
REM http://www.atlant1.com.ua/Settlers/~oberon
REM e-mail: oberon@webber.net.ua

DECLARE SUB SearchAll(ID&, StartID&)
DECLARE SUB TestAndApply()

GLOBAL o&,tt&
o&=0
tt&=0

on error goto handler

ret%=messagebox("Do you wish to apply Scale with Image to all outlines","Confirm",36)
if ret=7 then stop
WITHOBJECT "CorelDraw.automation.7"
	.UnSelectAll
	.SelectNextObject 0
	ID1& = .GetObjectsCDRStaticID()
	CALL SearchAll ID1&, 0
	.UnSelectAll
END WITHOBJECT
MESSAGE str(o&)+" outline(s) set to Scale with image."+chr(13)+str(tt&)+" object(s) processed."
STOP
HANDLER :
	IF ERRNUM = 1000 THEN
		MESSAGEBOX "No active document or no objects in drawing","Message",16
	ELSE
		MESSAGEBOX "Error "+STR(ERRNUM)+" encountered","Message",16
	END IF
stop

SUB SearchAll(ID&, StartID&)
LocalID& = ID
LocalStart& = StartID
WITHOBJECT "CorelDraw.Automation.7"
	DIM Booltest as boolean
	Booltest = TRUE
		DO WHILE Booltest
			IF .GetObjectType() = 12 THEN
				GroupID& = .GetObjectsCDRStaticID()
				.SelectNextObject -1
				IDNext& = .GetObjectsCDRStaticID()
				CALL SearchAll IDNext, GroupID
				.SelectNextObject 0
			ELSE
				CALL TestAndApply
				.SelectNextObject 0
			END IF
			IF .GetObjectsCDRStaticID() = LocalID THEN Booltest = False
		LOOP
	.SelectObjectOfCDRStaticID LocalStart
END WITHOBJECT
END SUB

SUB TestAndApply
DIM Scaled as boolean,BehindFill as boolean
WITHOBJECT "CorelDraw.Automation.7"
tt&=tt&+1
.GetOutline Width&, OutlineType&, EndCaps&, JoinType&, Aspect&, Angle&, DotDash&, RArrow&, LArrow&, BehindFill, Scaled
if outlineType&<>0 and not Scaled then
  .ApplyOutline Width&,OutlineType&,EndCaps&,JoinType&,Aspect&,Angle&,DotDash&,RArrow&,LArrow&,BehindFill,0,0,TRUE
  o=o+1
end if
END WITHOBJECT
END SUB


