/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandomMobs {
    private static Map textureVariantsMap = new HashMap();
    private static boolean initialized = false;
    private static Random random = new Random();

    public static void entityLoaded(lq entity) {
        int randomId;
        if (entity.cu != null) {
            return;
        }
        if (!(entity instanceof md)) {
            return;
        }
        if (entity instanceof qx) {
            return;
        }
        md el = (md)entity;
        in ws2 = Config.getWorldServer();
        if (ws2 == null) {
            el.cu = "123" + el.k;
            return;
        }
        lq es2 = ws2.a(entity.k);
        if (!(es2 instanceof md)) {
            return;
        }
        md els = (md)es2;
        el.persistentId = randomId = els.persistentId;
        els.cu = el.cu = "" + randomId;
    }

    public static void worldChanged(yc oldWorld, yc newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.A();
            for (int e2 = 0; e2 < entityList.size(); ++e2) {
                lq entity = (lq)entityList.get(e2);
                RandomMobs.entityLoaded(entity);
            }
        }
    }

    public static int getTexture(String skinUrl, String texture) {
        if (!initialized) {
            RandomMobs.initialize();
        }
        if (texture == null) {
            return -1;
        }
        if (skinUrl == null) {
            return -1;
        }
        if (skinUrl.length() <= 1) {
            return -1;
        }
        char ch2 = skinUrl.charAt(0);
        if (ch2 < '0' || ch2 > '9') {
            return -1;
        }
        int num = Math.abs(skinUrl.hashCode());
        String[] texs = (String[])textureVariantsMap.get(texture);
        if (texs == null) {
            texs = RandomMobs.getTextureVariants(texture);
            textureVariantsMap.put(texture, texs);
        }
        if (texs == null || texs.length <= 0) {
            return -1;
        }
        int index = num % texs.length;
        String tex = texs[index];
        return Config.getMinecraft().o.b(tex);
    }

    private static String[] getTextureVariants(String texture) {
        String suffix;
        bba renderEngine = Config.getMinecraft().o;
        renderEngine.b(texture);
        String[] texs = new String[]{texture};
        int pointPos = texture.lastIndexOf(46);
        if (pointPos < 0) {
            return texs;
        }
        String prefix = texture.substring(0, pointPos);
        int countVariants = RandomMobs.getCountTextureVariants(texture, prefix, suffix = texture.substring(pointPos));
        if (countVariants <= 1) {
            return texs;
        }
        texs = new String[countVariants];
        texs[0] = texture;
        for (int i2 = 1; i2 < texs.length; ++i2) {
            String texName;
            int texNum = i2 + 1;
            texs[i2] = texName = prefix + texNum + suffix;
            renderEngine.b(texName);
        }
        Config.dbg("RandomMobs: " + texture + ", variants: " + texs.length);
        return texs;
    }

    private static int getCountTextureVariants(String texture, String prefix, String suffix) {
        bba renderEngine = Config.getMinecraft().o;
        int maxNum = 1000;
        for (int num = 2; num < maxNum; ++num) {
            String variant = prefix + num + suffix;
            try {
                InputStream in2 = renderEngine.k.e().a(variant);
                if (in2 != null) {
                    in2.close();
                    continue;
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return num - 1;
        }
        return maxNum;
    }

    public static void resetTextures() {
        textureVariantsMap.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        initialized = true;
        RandomMobs.getTexture("100", "/mob/bat.png");
        RandomMobs.getTexture("100", "/mob/cavespider.png");
        RandomMobs.getTexture("100", "/mob/chicken.png");
        RandomMobs.getTexture("100", "/mob/cow.png");
        RandomMobs.getTexture("100", "/mob/creeper.png");
        RandomMobs.getTexture("100", "/mob/enderman.png");
        RandomMobs.getTexture("100", "/mob/ghast.png");
        RandomMobs.getTexture("100", "/mob/ghast_fire.png");
        RandomMobs.getTexture("100", "/mob/lava.png");
        RandomMobs.getTexture("100", "/mob/ozelot.png");
        RandomMobs.getTexture("100", "/mob/pig.png");
        RandomMobs.getTexture("100", "/mob/pigzombie.png");
        RandomMobs.getTexture("100", "/mob/sheep.png");
        RandomMobs.getTexture("100", "/mob/sheep_fur.png");
        RandomMobs.getTexture("100", "/mob/skeleton.png");
        RandomMobs.getTexture("100", "/mob/skeleton_wither.png");
        RandomMobs.getTexture("100", "/mob/slime.png");
        RandomMobs.getTexture("100", "/mob/spider.png");
        RandomMobs.getTexture("100", "/mob/squid.png");
        RandomMobs.getTexture("100", "/mob/wolf.png");
        RandomMobs.getTexture("100", "/mob/zombie.png");
    }
}

